/*
 * Copyright (c) 1996-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.ActivationDataFlavor;

import java.io.*;
import java.util.Locale;
import java.awt.datatransfer.*;
import javax.activation.*;
import com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * We create a TestActivationDataFlavor object then invoke 
 * testNormalizeMimeTypeParameter() method which in turn calls
 * normalizeMimeTypeParameter() api, if it returns the expected
 * string value then this testcase passes, otherwsie it fails.
 */

public class normalizeMimeTypeParameter_Test extends MultiTest {

    // main
    public static void main(String[] args)
    {
	Test t = new normalizeMimeTypeParameter_Test(); 
	Status s = t.run(args, new PrintWriter(System.err, true), new PrintWriter(System.out, true)); 
	s.exit(); 
    }

    // Tests for equals:
    public Status normalizeMimeTypeParameter()
    {
	String parameterName = "charset";
	String parameterValue = "US-ASCII";
	String expectedValue = parameterValue.toLowerCase(Locale.ENGLISH);

	// actual type doesn't matter
	TestActivationDataFlavor adf = new TestActivationDataFlavor("text/plain","My DataFlavor");
		// API TEST
	if(expectedValue.equalsIgnoreCase(adf.testNormalizeMimeTypeParameter(parameterName,parameterValue)))
	    return Status.passed("normalizeMimeTypeParameter() test succeeded");
	else
	    return Status.failed("normalizeMimeTypeParameter() test failed: "
				+ adf.testNormalizeMimeTypeParameter(parameterName,parameterValue)
				+ " != " + expectedValue);
    }
}
