/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.ActivationDataFlavor;

import java.io.*;
import java.awt.datatransfer.*;
import javax.activation.*;
import com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 

/**
 * Here we test the three ActivationDataFlavor(..) constructors.
 * We do this by passing the expected parameters and then by verifying
 * that ActivationDataFlavor object type get created. If so then this
 * testcase passes otherwise it fails.
 */

public class ActivationDataFlavor_Test extends MultiTest {

    // main
    public static void main(String[] args)
    {
	Test t = new ActivationDataFlavor_Test();
	Status s = t.run(args, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	s.exit();
    }

    // Tests for ActivationDataFlavor constructors:
    public Status testForActivationDF1()
    {
	return callADF_1("text/plain", "text/plain", true);
    }

    public Status testForActivationDF2()
    {
	return callADF_2();   
    }

    public Status testForActivationDF3()
    {
	return callADF_3();
    }

    // private implementation methods

    private Status callADF_1(String adfMimeType,String dfMimeType,boolean expectedResult)
    {
	ActivationDataFlavor adf = new ActivationDataFlavor(adfMimeType,adfMimeType);	// API TEST
	DataFlavor df = new DataFlavor(dfMimeType,dfMimeType);

	boolean result = adf.equals(df);

	if( result == expectedResult)
	    return Status.passed("ActivationDataFlavor(String,String) test succeeded");
	else
	    return Status.failed("ActivationDataFlavor(String,String) test failed");
    }

    private Status callADF_2()
    {
        String humanName = "Human Presentable Name";
        Class myClass = humanName.getClass();

        ActivationDataFlavor adf = new ActivationDataFlavor(myClass,humanName);	// API TEST

        if(adf.getRepresentationClass().equals(myClass))
            return Status.passed("ActivationDataFlavor(Class,String) test succeeded");
        else
            return Status.failed("ActivationDataFlavor(Class,String) test failed");
    }

    private Status callADF_3()
    {
        String humanName = "Human Presentable Name";
        Class myClass = humanName.getClass();
	String mimeType = "text/plain";

        ActivationDataFlavor adf = new ActivationDataFlavor(myClass,mimeType,humanName); // API TEST

        if(adf.getRepresentationClass().equals(myClass))
            return Status.passed("ActivationDataFlavor(Class,String,String) test succeeded");
        else
            return Status.failed("ActivationDataFlavor(Class,String,String) test failed");
    }
}
