/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.services.Message;
import com.sun.javatest.services.ProcessParams;
import com.sun.javatest.services.ServiceExecutor;
import com.sun.jck.lib.JCovRemoteSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingExecutor
implements ServiceExecutor {
    private Process proc;
    private JCovRemoteSupport jcovSupport;
    private ExecutorService logReaderExecutor;
    private ConcurrentLinkedQueue<String> logCache = new ConcurrentLinkedQueue();

    protected List<String> getCommand(Message message) {
        ProcessParams processParams = (ProcessParams)message.getContent();
        return processParams.getCommand();
    }

    protected Map<String, String> getEnv(Message message) {
        ProcessParams processParams = (ProcessParams)message.getContent();
        return processParams.getEnvironment();
    }

    protected File getWorkDir(Message message) {
        ProcessParams processParams = (ProcessParams)message.getContent();
        return processParams.getWorkDirectory();
    }

    protected void checkMessage(Message message, Message.MessageType messageType) throws BadMessageException {
        if (message.getType() != messageType) {
            throw new BadMessageException();
        }
        if (messageType == Message.MessageType.START && !(message.getContent() instanceof ProcessParams)) {
            throw new BadMessageException();
        }
    }

    @Override
    public Message startService(Message message) {
        Object object;
        String string = null;
        try {
            this.checkMessage(message, Message.MessageType.START);
        }
        catch (BadMessageException badMessageException) {
            return new Message(Message.MessageType.ERROR, badMessageException);
        }
        List<String> list = this.getCommand(message);
        this.jcovSupport = JCovRemoteSupport.getInstance(list);
        if (this.jcovSupport != null && this.jcovSupport.wasCommandAdjusted()) {
            string = "Adjusted for JCov: " + list;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        Map<String, String> map = this.getEnv(message);
        if (map != null && map.size() > 0) {
            object = processBuilder.environment();
            object.putAll(map);
        }
        if ((object = this.getWorkDir(message)) != null && ((File)object).exists()) {
            processBuilder.directory((File)object);
        }
        try {
            this.proc = processBuilder.start();
        }
        catch (IOException iOException) {
            return new Message(Message.MessageType.ERROR, iOException);
        }
        this.stopLogReader();
        this.startLogReader();
        return this.addProcessLog(new Message(Message.MessageType.STARTED, (Serializable)((Object)string)));
    }

    @Override
    public Message stopService(Message message) {
        try {
            this.checkMessage(message, Message.MessageType.STOP);
        }
        catch (BadMessageException badMessageException) {
            return new Message(Message.MessageType.ERROR, badMessageException);
        }
        if (this.proc == null) {
            return new Message(Message.MessageType.ERROR, (Serializable)((Object)"Process was not started"));
        }
        if (!this.isProcessAlive()) {
            return new Message(Message.MessageType.ERROR, null);
        }
        if (this.jcovSupport != null) {
            this.jcovSupport.sendSaveAndExitCommands(null);
        }
        this.proc.destroy();
        try {
            this.proc.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Message message2 = this.addProcessLog(new Message(Message.MessageType.STOPPED, (Serializable)((Object)("Process stopped successfully.\nExit value: " + this.proc.exitValue()))));
        return message2;
    }

    @Override
    public Message isAlive(Message message) {
        try {
            this.checkMessage(message, Message.MessageType.IS_ALIVE);
        }
        catch (BadMessageException badMessageException) {
            return new Message(Message.MessageType.ERROR, badMessageException);
        }
        if (this.proc != null) {
            Message message2 = this.isProcessAlive() ? new Message(Message.MessageType.ALIVE, null) : new Message(Message.MessageType.NOT_ALIVE, null);
            return this.addProcessLog(message2);
        }
        return new Message(Message.MessageType.NOT_ALIVE, null);
    }

    @Override
    public InputStream getServiceErrorStream() {
        if (this.proc != null) {
            return this.proc.getErrorStream();
        }
        return null;
    }

    @Override
    public InputStream getServiceOutputStream() {
        if (this.proc != null) {
            return this.proc.getInputStream();
        }
        return null;
    }

    public boolean isProcessAlive() {
        try {
            int n = this.proc.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    protected String getLogged() {
        String string;
        if (this.logCache.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.logCache.poll()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected void startLogReader() {
        this.logReaderExecutor = Executors.newFixedThreadPool(2);
        this.logReaderExecutor.submit(new ProcReader(this.getServiceOutputStream()));
        this.logReaderExecutor.submit(new ProcReader(this.getServiceErrorStream()));
    }

    protected void stopLogReader() {
        if (this.logReaderExecutor == null) {
            return;
        }
        try {
            this.logReaderExecutor.shutdown();
            if (!this.logReaderExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.logReaderExecutor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            Thread.currentThread().interrupt();
            this.logReaderExecutor.shutdownNow();
        }
    }

    synchronized Message addProcessLog(Message message) {
        String string;
        if (this.proc == null) {
            return message;
        }
        if (this.logReaderExecutor == null || this.logReaderExecutor.isShutdown()) {
            return message;
        }
        if (!this.isProcessAlive()) {
            this.stopLogReader();
        }
        if ((string = this.getLogged()) == null || string.length() == 0) {
            return message;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Serializable serializable = message.getContent();
        if (serializable instanceof String) {
            stringBuffer.append((String)((Object)serializable));
        }
        stringBuffer.append("\nProcess Output:\n");
        stringBuffer.append(string);
        Message message2 = new Message(message.getType(), (Serializable)((Object)stringBuffer.toString()));
        return message2;
    }

    public class ProcReader
    implements Runnable {
        private BufferedReader reader;

        public ProcReader(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void run() {
            try {
                String string;
                while ((string = this.reader.readLine()) != null) {
                    LoggingExecutor.this.logCache.add(string);
                }
            }
            catch (IOException iOException) {
            }
        }
    }

    public static class BadMessageException
    extends Exception {
    }
}

