/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.TestSuite;
import com.sun.javatest.services.LocalConnector;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceProperties;
import com.sun.javatest.services.ServiceReader;
import com.sun.javatest.services.TestPath;
import com.sun.jck.services.TestMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyServiceReader
implements ServiceReader {
    private File xml;
    private Document doc;
    private TestSuite ts;
    public static final String SERVICES_XML = File.separator + "lib" + File.separator + "services.xml";

    @Override
    public void init(TestSuite testSuite, String[] stringArray) {
        Object object;
        this.ts = testSuite;
        File file = testSuite.getRootDir();
        if (stringArray == null || stringArray.length == 0) {
            this.xml = new File(file, SERVICES_XML);
        } else {
            object = stringArray[0].replace("/", File.separator);
            this.xml = new File(file, (String)object);
        }
        try {
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            this.doc = documentBuilder.parse(this.xml);
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Service> readServices() {
        ServiceProperties serviceProperties = this.readProperties(this.doc);
        return this.readServices(this.doc, serviceProperties);
    }

    @Override
    public Set<TestPath> readTestServiceMap() {
        HashSet<TestPath> hashSet = new HashSet<TestPath>();
        NodeList nodeList = this.doc.getElementsByTagName("testpath");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = null;
            String string2 = null;
            if (element.hasAttribute("path")) {
                string = element.getAttribute("path");
            }
            if (element.hasAttribute("matcher")) {
                string2 = element.getAttribute("matcher");
            }
            TestMapping testMapping = new TestMapping(this.ts, string, string2);
            NodeList nodeList2 = element.getElementsByTagName("service");
            Set<String> set = ((TestPath)testMapping).getServices();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                set.add(element2.getAttribute("refid"));
            }
            hashSet.add(testMapping);
        }
        return hashSet;
    }

    private ServiceProperties readProperties(Document document) {
        Object object;
        Object object2;
        Object object3;
        ServiceProperties serviceProperties = new ServiceProperties(null);
        NodeList nodeList = document.getElementsByTagName("propertyfile");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            try {
                Element element = (Element)nodeList.item(i);
                object3 = element.getAttribute("file");
                object2 = new File(this.xml.getAbsolutePath() + (String)object3);
                object = new Properties();
                ((Properties)object).load(new FileInputStream((File)object2));
                for (Object object4 : ((Properties)object).keySet()) {
                    String string = (String)object4;
                    serviceProperties.addProperty(string, ((Properties)object).getProperty(string));
                }
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        NodeList nodeList2 = document.getElementsByTagName("property");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object3 = (Element)nodeList2.item(i);
            object2 = object3.getAttribute("name");
            object = null;
            if (object3.hasAttribute("value")) {
                object = object3.getAttribute("value");
            }
            serviceProperties.addProperty((String)object2, (String)object);
        }
        if (serviceProperties.isEmpty()) {
            return null;
        }
        return serviceProperties;
    }

    private Map<String, Service> readServices(Document document, ServiceProperties serviceProperties) {
        ConcurrentHashMap<String, Service> concurrentHashMap = new ConcurrentHashMap<String, Service>();
        Element element = document.getDocumentElement();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !((Element)node).getNodeName().equals("service")) continue;
            try {
                Element element2 = (Element)node;
                String string = element2.getAttribute("id");
                String string2 = element2.getAttribute("class");
                String string3 = element2.getAttribute("description");
                Service service = (Service)this.ts.loadClass(string2).newInstance();
                service.setId(string);
                service.setDescription(string3);
                ServiceProperties serviceProperties2 = new ServiceProperties(serviceProperties);
                NodeList nodeList = element2.getElementsByTagName("arg");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    String string4 = element3.getAttribute("name");
                    String string5 = null;
                    if (element3.hasAttribute("value")) {
                        string5 = element3.getAttribute("value");
                    }
                    serviceProperties2.addProperty(string4, string5);
                }
                service.setProperties(serviceProperties2);
                LocalConnector localConnector = new LocalConnector(service.getDefaultServiceExecutor());
                service.setConnector(localConnector);
                concurrentHashMap.put(service.getId(), service);
                continue;
            }
            catch (TestSuite.Fault fault) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return concurrentHashMap;
    }
}

