/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.multijvm.group;

import com.sun.javatest.agent.SocketConnection;
import com.sun.jck.lib.multijvm.group.AgentTask;
import com.sun.jck.lib.multijvm.group.util.Util;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManager
implements Runnable,
Util.ArgHandler,
Closeable {
    protected Map<String, AgentTask> agentMap = Collections.synchronizedMap(new HashMap());
    protected ConcurrentMap<List<String>, BlockingQueue<AgentTask>> queueMap = new ConcurrentHashMap<List<String>, BlockingQueue<AgentTask>>();
    private ServerSocket server;
    private CountDownLatch serverStarted = new CountDownLatch(1);
    private ExecutorService executor = Executors.newCachedThreadPool();
    private volatile int serverPort = 0;
    private long timeout = 60000L;
    protected static Map<List<String>, TaskManager> managerMap = Collections.synchronizedMap(new HashMap());
    private List<String> key;
    private volatile boolean closed;
    private volatile Throwable exception;
    private volatile ScheduledFuture closeFuture;
    private final AtomicInteger uidCounter = new AtomicInteger(0);
    private boolean debug = false;

    public TaskManager(List<String> list) {
        this.key = list;
        Util.decodeAllArgs(list, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager getManager(List<String> list) throws Throwable {
        Map<List<String>, TaskManager> map = managerMap;
        synchronized (map) {
            TaskManager taskManager = managerMap.get(list);
            if (taskManager == null || taskManager.cancelClose()) {
                taskManager = new TaskManager(list);
                taskManager.start();
                managerMap.put(list, taskManager);
            }
            return taskManager;
        }
    }

    public boolean cancelClose() {
        if (this.closeFuture != null && !this.closeFuture.isDone()) {
            this.closeFuture.cancel(true);
        }
        return this.closed;
    }

    @Override
    public int decodeArg(List<String> list, int n) {
        if ("-serverPort".equals(list.get(n))) {
            this.serverPort = Integer.parseInt(list.get(++n));
            return 2;
        }
        if ("-timeout".equals(list.get(n))) {
            float f = Float.parseFloat(list.get(++n));
            this.timeout = Math.round(f * 1000.0f);
            return 2;
        }
        if ("-debug".equals(list.get(n))) {
            this.debug = true;
            return 1;
        }
        return 0;
    }

    private void log(String string) {
        if (this.debug) {
            Util.printLog(this, string);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.server = new ServerSocket(this.serverPort);
            this.serverPort = this.server.getLocalPort();
            this.serverStarted.countDown();
            while (!this.server.isClosed()) {
                Socket socket = this.server.accept();
                try {
                    SocketConnection socketConnection = new SocketConnection(socket);
                    String string = new DataInputStream(new BufferedInputStream(socketConnection.getInputStream())).readUTF();
                    AgentTask agentTask = this.agentMap.get(string);
                    if (agentTask == null) continue;
                    agentTask.setConnection(socketConnection);
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.exception = throwable;
            this.serverStarted.countDown();
        }
        finally {
            this.close();
        }
    }

    public void start() throws Throwable {
        this.executor.execute(this);
        this.serverStarted.await();
        if (this.exception != null) {
            throw this.exception;
        }
        this.closeFuture = Util.scheduleClose(this, this.timeout);
    }

    public BlockingQueue<AgentTask> getAgentQueue(List<String> list) {
        BlockingQueue blockingQueue = (BlockingQueue)this.queueMap.get(list);
        if (blockingQueue == null) {
            PriorityBlockingQueue priorityBlockingQueue = new PriorityBlockingQueue();
            BlockingQueue blockingQueue2 = this.queueMap.putIfAbsent(list, priorityBlockingQueue);
            blockingQueue = blockingQueue2 == null ? priorityBlockingQueue : blockingQueue2;
        }
        return blockingQueue;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void addAgent(AgentTask agentTask) {
        this.cancelClose();
        this.agentMap.put(agentTask.getId(), agentTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgent(AgentTask agentTask) {
        this.getAgentQueue(agentTask.getKey()).remove(agentTask);
        Map<String, AgentTask> map = this.agentMap;
        synchronized (map) {
            this.agentMap.remove(agentTask.getId());
            if (this.agentMap.size() == 0) {
                this.cancelClose();
                this.closeFuture = Util.scheduleClose(this, this.timeout);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            managerMap.remove(this.key);
            try {
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (AgentTask agentTask : new CopyOnWriteArrayList<AgentTask>(this.agentMap.values())) {
                agentTask.close();
            }
            this.log("manager closed");
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String generarateUID() {
        return String.valueOf(this.uidCounter.incrementAndGet());
    }

    public String toString() {
        return "TaskManager(key=" + this.key + ",port=" + this.serverPort + ",closed=" + this.closed + ")";
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                for (TaskManager taskManager : new CopyOnWriteArrayList<TaskManager>(managerMap.values())) {
                    taskManager.close();
                }
            }
        });
    }
}

