/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.jck.lib.Arguments;
import com.sun.jck.lib.Invoker;
import com.sun.jck.lib.WSGenTool;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSGenInvoker
extends Invoker {
    protected String className;
    protected String sei;
    protected File wsdlLocation;

    public static void main(String[] stringArray) {
        int n;
        try {
            n = new WSGenInvoker(stringArray).execute(System.out, System.err);
        }
        catch (Invoker.ArgumentException argumentException) {
            n = -1;
        }
        catch (Invoker.InvokeException invokeException) {
            invokeException.printStackTrace(System.err);
            n = -1;
        }
        System.exit(n);
    }

    public WSGenInvoker(String[] stringArray) {
        super(stringArray);
    }

    public WSGenInvoker(Arguments arguments) {
        super(arguments);
    }

    @Override
    public void processArguments() throws Invoker.ArgumentException {
        super.processArguments();
        if (this.args.contains("-class")) {
            this.className = this.args.getValue("-class");
        }
        if (this.className == null) {
            throw new Invoker.ArgumentException("No class name specified after the option '-class'.");
        }
        this.args.removeArgs("-class", 2);
        if (this.args.contains("-sei")) {
            this.sei = this.args.getValue("-sei");
        }
        if (this.sei == null) {
            throw new Invoker.ArgumentException("No class name specified after the option '-sei'.");
        }
        this.args.removeArgs("-sei", 2);
        if (this.outDir == null) {
            throw new Invoker.ArgumentException("No '-d <path>' option supplied.");
        }
        this.wsdlLocation = this.outDir;
        this.args.removeArgs("-d", 2);
        this.args.setArgs(this.args.getTail("-", false));
    }

    @Override
    public int invoke(PrintStream printStream, PrintStream printStream2) throws Invoker.InvokeException {
        try {
            Class<?> clazz = Class.forName(this.className);
            WSGenTool wSGenTool = (WSGenTool)WSGenTool.class.cast(clazz.newInstance());
            Integer n = wSGenTool.generate(WSGenInvoker.getSeiList(this.sei), this.outDir, this.args, printStream, printStream2);
            if (n instanceof Integer) {
                int n2 = n;
                return n2 == 0 ? 0 : -1;
            }
            throw new Invoker.InvokeException("Unexpected return value from generator: " + n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Invoker.InvokeException("Can't load the class: " + this.className);
        }
        catch (ClassCastException classCastException) {
            throw new Invoker.InvokeException("The " + this.className + " class does not implement interface com.sun.jck.lib.WSGenTool");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Invoker.InvokeException("The class or its nullary constructor is not accessible: " + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new Invoker.InvokeException("Can't instantiate the class: " + this.className);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Invoker.InvokeException("Generator threw exception: " + illegalArgumentException.getMessage());
        }
        catch (Invoker.ArgumentException argumentException) {
            throw new Invoker.InvokeException("Argument parser threw exception: " + argumentException.getMessage());
        }
    }

    public static Collection<String> getSeiList(String string) throws Invoker.ArgumentException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split(":");
        arrayList.add(stringArray[0]);
        int n = stringArray[0].lastIndexOf(46);
        if (n < 0) {
            throw new Invoker.ArgumentException("SEI is not fully qualified in the argument string: " + string);
        }
        String string2 = stringArray[0].substring(0, n + 1);
        for (int i = 1; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i].lastIndexOf(46) < 0 ? string2 + stringArray[i] : stringArray[i]);
        }
        return arrayList;
    }
}

