/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;

public abstract class MessageClient
implements Runnable {
    private String name;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private Thread listener;
    private static final int STARTING = 0;
    private static final int RUNNING = 1;
    private static final int CLOSING = 2;
    private static final int CLOSED = 3;
    private int state;
    static final int NAME = 1;
    static final int BROADCAST = 2;
    static final int SEND = 3;
    static final int MESSAGE = 100;

    public MessageClient(String string, String string2) throws IOException {
        this(string, MessageClient.openSocket(string2));
    }

    public MessageClient(String string, String string2, int n) throws IOException {
        this(string, new Socket(string2, n));
    }

    public MessageClient(String string, Socket socket) throws IOException {
        this.name = string;
        this.socket = socket;
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public synchronized void broadcast(String[] stringArray) throws IOException {
        if (this.listener == null) {
            throw new IllegalStateException();
        }
        this.out.writeByte(2);
        this.out.writeShort(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.out.writeUTF(stringArray[i]);
        }
        this.out.flush();
    }

    public synchronized void send(String string, String[] stringArray) throws IOException {
        if (this.listener == null) {
            throw new IllegalStateException();
        }
        this.out.writeByte(3);
        this.out.writeUTF(string);
        this.out.writeShort(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.out.writeUTF(stringArray[i]);
        }
        this.out.flush();
    }

    public synchronized void close() {
        if (this.state < 2) {
            this.state = 2;
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listener.interrupt();
            this.listener = null;
        }
    }

    public synchronized void start() throws InterruptedException {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = new Thread((Runnable)this, "MessageClient");
        this.listener.start();
        while (this.state == 0) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MessageClient messageClient = this;
        synchronized (messageClient) {
            if (this.listener == null) {
                this.listener = Thread.currentThread();
            } else if (this.listener != Thread.currentThread()) {
                throw new IllegalStateException();
            }
        }
        try {
            this.out.writeByte(1);
            this.out.writeUTF(this.name);
            this.out.flush();
            messageClient = this;
            synchronized (messageClient) {
                this.state = 1;
                this.notifyAll();
            }
            while (this.state == 1) {
                byte by;
                try {
                    by = this.in.readByte();
                }
                catch (EOFException eOFException) {
                    MessageClient messageClient2 = this;
                    synchronized (messageClient2) {
                        this.state = 3;
                        this.notifyAll();
                    }
                    return;
                }
                switch (by) {
                    case 100: {
                        String string = this.in.readUTF();
                        int n = this.in.readShort();
                        String[] stringArray = new String[n];
                        for (int i = 0; i < n; ++i) {
                            stringArray[i] = this.in.readUTF();
                        }
                        this.handleMessage(string, stringArray);
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        finally {
            MessageClient messageClient3 = this;
            synchronized (messageClient3) {
                this.state = 3;
                this.notifyAll();
            }
        }
    }

    public synchronized void waitUntilClosed() throws InterruptedException {
        while (this.state != 3) {
            this.wait();
        }
    }

    protected abstract void handleException(Exception var1);

    protected abstract void handleMessage(String var1, String[] var2);

    private static Socket openSocket(String string) throws IOException {
        int n = string.indexOf(58);
        if (n == -1) {
            throw new IllegalArgumentException("no port specified");
        }
        return new Socket(string.substring(0, n), Integer.parseInt(string.substring(n + 1)));
    }
}

