/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.Checklist;
import com.sun.interview.ChoiceQuestion;
import com.sun.interview.DirectoryFileFilter;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.jck.interview.EnvironmentInterview;
import com.sun.jck.interview.GroupModeSupport;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKExportedQuestion;
import com.sun.jck.interview.JCKFileQuestion;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.interview.JCKStringQuestion;
import com.sun.jck.interview.JCKYesNoQuestion;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.RuntimeNetworkInterview;
import com.sun.jck.interview.ServicesInterview;
import com.sun.jck.interview.SwitchInterviewQuestion;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

class RuntimeTestExecuteInterview
extends JCKEnvInterview {
    private GroupModeSupport groupModeSupport;
    private Question qIntro1 = new NullQuestion(this, "intro1"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isLocal()) {
                return RuntimeTestExecuteInterview.this.qClassPath;
            }
            String string = System.getProperty("jck.classLoaderMode");
            if (string != null && string.equals("old")) {
                return RuntimeTestExecuteInterview.this.qCreateClassLoaders;
            }
            return RuntimeTestExecuteInterview.this.qAdditionalClasspath;
        }

        public boolean isHidden() {
            return true;
        }
    };
    private Question qIntro = new NullQuestion(this, "intro"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            ServicesInterview servicesInterview = RuntimeTestExecuteInterview.this.parent.getServicesInterview();
            if (!testPlatformInterview.isMultiJVM() && !servicesInterview.areServicesOn()) {
                return RuntimeTestExecuteInterview.this.qIntro1;
            }
            if (testPlatformInterview.isLocal()) {
                return RuntimeTestExecuteInterview.this.qCmdAsFile;
            }
            return RuntimeTestExecuteInterview.this.qCmdAsString;
        }

        public void export(Map map) {
            String string;
            String string2 = null;
            String string3 = null;
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            boolean bl = testPlatformInterview.isGroupMode() && RuntimeTestExecuteInterview.this.groupModeSupport.isGroupModeEnabled();
            map.put("testExecute.isGroupMode", String.valueOf(bl));
            char c = testPlatformInterview.getFileSep();
            map.put("platform.fileSeparator", String.valueOf(c));
            if (testPlatformInterview.isMultiJVM()) {
                if (testPlatformInterview.isUseAgent()) {
                    string = RuntimeTestExecuteInterview.this.getAgentOtherJVMCommand(false, false);
                    if (bl) {
                        string2 = RuntimeTestExecuteInterview.this.getAgentOtherJVMCommand(true, false);
                    }
                    string3 = RuntimeTestExecuteInterview.this.getAgentOtherJVMCommand(false, true);
                } else {
                    string = RuntimeTestExecuteInterview.this.getOtherJVMCommand(false, false);
                    if (bl) {
                        string2 = RuntimeTestExecuteInterview.this.getOtherJVMCommand(true, false);
                    }
                    string3 = RuntimeTestExecuteInterview.this.getOtherJVMCommand(false, true);
                }
            } else {
                String string4 = System.getProperty("jck.classLoaderMode");
                if (string4 != null && string4.equals("old")) {
                    string = RuntimeTestExecuteInterview.this.getAgentSameJVMCommand();
                } else {
                    string = RuntimeTestExecuteInterview.this.getAgentSameJVMSeparateCLCommand();
                    String string5 = RuntimeTestExecuteInterview.this.getAgentSameJVMCommand();
                    map.put("command.testExecuteShared", string5);
                }
            }
            map.put("command.testExecute", string);
            if (string2 != null) {
                map.put("command.testExecute.group", string2);
            }
            if (string3 != null) {
                map.put("command.testExecuteJar", string3);
            }
            map.put("platform.concurrentShortDelay", "500");
            map.put("platform.imageTimeout", "5000");
            map.put("pathTo.java", RuntimeTestExecuteInterview.this.getPathToJava(testPlatformInterview));
        }
    };
    private YesNoQuestion qCreateClassLoaders = new YesNoQuestion(this, "createClassLoaders"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (this.value == null) {
                return null;
            }
            if (this.getValue() == "Yes") {
                return RuntimeTestExecuteInterview.this.qAdditionalClasspath;
            }
            if (testPlatformInterview.isNativeCodeSupported()) {
                if (testPlatformInterview.isJVMTISupported()) {
                    return RuntimeTestExecuteInterview.this.qJVMTI;
                }
                return RuntimeTestExecuteInterview.this.qJMX;
            }
            return RuntimeTestExecuteInterview.this.qEnd;
        }
    };
    private FileQuestion qCmdAsFile = new FileQuestion(this, "cmdAsFile"){

        protected Question getNext() {
            try {
                if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled() && !this.value.isFile()) {
                    return ((RuntimeTestExecuteInterview)RuntimeTestExecuteInterview.this).parent.qNoFileError;
                }
            }
            catch (SecurityException securityException) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qIntro1;
        }

        public boolean isValueValid() {
            return this.value != null && this.value.getPath().length() > 0;
        }

        public void export(Map map) {
            if (this.value == null) {
                return;
            }
            ServicesInterview servicesInterview = RuntimeTestExecuteInterview.this.parent.getServicesInterview();
            servicesInterview.exportJavaHome(this.value.getPath(), map);
        }
    };
    private StringQuestion qCmdAsString = new StringQuestion(this, "cmdAsString"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qIntro1;
        }

        public void export(Map map) {
            ServicesInterview servicesInterview = RuntimeTestExecuteInterview.this.parent.getServicesInterview();
            servicesInterview.exportJavaHome(this.value, map);
        }
    };
    private final String ENV = "environment variable";
    private final String OPT = "command line option";
    private ChoiceQuestion qClassPath = new ChoiceQuestion(this, "classpath"){
        {
            this.setChoices(new String[]{null, "environment variable", "command line option"});
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "environment variable") {
                return RuntimeTestExecuteInterview.this.qClassPathEnv;
            }
            return RuntimeTestExecuteInterview.this.qClassPathOpt;
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "command line option";
        }
    };
    private StringQuestion qClassPathEnv = new StringQuestion(this, "classpathEnv"){
        {
            this.setSuggestions(new String[]{"", "CLASSPATH"});
        }

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (this.value == null || this.value.trim().length() == 0) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qAdditionalClasspath;
        }
    };
    private StringQuestion qClassPathOpt = new StringQuestion(this, "classpathOpt"){
        {
            this.setSuggestions(new String[]{"", "-classpath #", "/cp:#"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.trim().length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qAdditionalClasspath;
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private FileListQuestion qAdditionalClasspath = new FileListQuestion(this, "additionalClasspath"){
        {
            FileFilter[] fileFilterArray = new FileFilter[]{new DirectoryFileFilter("Directories"), new ExtensionFileFilter(".zip", "ZIP Files"), new ExtensionFileFilter(".jar", "JAR Files")};
            this.setFilters(fileFilterArray);
            this.setDefaultValue(null);
        }

        public File getBaseDirectory() {
            return new File(System.getProperty("user.dir"));
        }

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            return testPlatformInterview.isMultiJVM() ? RuntimeTestExecuteInterview.this.qJarExecution : RuntimeTestExecuteInterview.this.qAfterJarExecutionOpt();
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (this.value == null && bl) {
                this.setValue(this.getDefValues());
            }
            return super.isHidden();
        }

        private File[] getDefValues() {
            File file = RuntimeTestExecuteInterview.this.getJavaHome();
            if (file != null) {
                File file2 = new File(new File(file, "lib"), "tools.jar");
                try {
                    if (file2.isFile()) {
                        return new File[]{file2};
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return null;
        }
    };
    private TestArgsQuestion qJarExecution = new TestArgsQuestion("jarExecution"){

        public boolean isHidden() {
            boolean bl = this.matchTests();
            if (bl && !RuntimeTestExecuteInterview.this.parent.isSimple()) {
                return false;
            }
            this.setValue(this.getDefValue());
            return true;
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeTestExecuteInterview.this.qJarExecutionOpt;
            }
            return RuntimeTestExecuteInterview.this.qAfterJarExecutionOpt();
        }

        String[] getTestURL() {
            return new String[]{"api/java_awt/SplashScreen", "api/javax_sound"};
        }

        public void export(Map map) {
            String string = "platform.jarExecutionSupported";
            if (!RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview().isMultiJVM()) {
                map.put(string, "false");
            } else {
                map.put(string, String.valueOf(this.value == "Yes"));
            }
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private JCKStringQuestion qJarExecutionOpt = new JCKStringQuestion(this, "jarExecutionOpt"){
        private final String DEFAULT = "-jar #";
        {
            this.DEFAULT = "-jar #";
            this.setSuggestions(new String[]{"", "-jar #"});
            this.setDefaultValue("-jar #");
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.qJarExecution.isHidden();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        protected Question getNext() {
            if (this.value == null || this.value.trim().length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qAfterJarExecutionOpt();
        }

        public void export(Map map) {
            map.put("platform.jarExecutionOption", Utils.evalTemplate(this.value, "${jvmArgJarValue}"));
        }

        private String getDefValue() {
            return "-jar #";
        }
    };
    private YesNoQuestion qNativeLibrariesLocation = new YesNoQuestion(this, "nativeLibrariesLocation"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (this.value == "Yes") {
                if (testPlatformInterview.isLocal()) {
                    return RuntimeTestExecuteInterview.this.qNativeLibPathFileValue;
                }
                return RuntimeTestExecuteInterview.this.qNativeLibPathValue;
            }
            if (this.value == "No") {
                return RuntimeTestExecuteInterview.this.qJNI;
            }
            return null;
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
                return true;
            }
            return RuntimeTestExecuteInterview.this.qNativeLibPathFileValue.isHidden();
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private TestArgsQuestion qJNI = new TestArgsQuestion("jni"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            return this.getNext(testPlatformInterview.isJVMTISupported() ? RuntimeTestExecuteInterview.this.qJVMTI : RuntimeTestExecuteInterview.this.qJMX, testPlatformInterview.isJVMTISupported() ? RuntimeTestExecuteInterview.this.qJVMTI : RuntimeTestExecuteInterview.this.qJMX);
        }

        String[] getTestURL() {
            return new String[]{"vm", "api/javax_management", "api/java_lang/instrument"};
        }
    };
    private TestArgsQuestion qJVMTI = new TestArgsQuestion("jvmti"){

        protected Question getNext() {
            return this.getNext(RuntimeTestExecuteInterview.this.qJVMTIOptTempl, RuntimeTestExecuteInterview.this.qJMX);
        }

        String[] getTestURL() {
            return new String[]{"vm/jvmti"};
        }
    };
    private JCKStringQuestion qJVMTIOptTempl = new JCKStringQuestion(this, "jvmtiAgentOptionsTempl"){
        {
            this.setSuggestions(new String[]{"", "-agentlib:#=@"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("@") == -1) {
                return null;
            }
            if (RuntimeTestExecuteInterview.this.oneNativeLibrariesLocation()) {
                return RuntimeTestExecuteInterview.this.qJVMTILivePhase;
            }
            return RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview().isLocal() ? RuntimeTestExecuteInterview.this.qJVMTILibPathFileValue : RuntimeTestExecuteInterview.this.qJVMTILibPathValue;
        }

        public void export(Map map) {
            map.put("jvmtiAgentOptionsTempl", Utils.evalTemplate(this.value, "jckjvmti", "${jvmtiTestName}"));
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private JCKYesNoQuestion qJVMTILivePhase = new JCKYesNoQuestion(this, "jvmtiLivePhase"){

        protected Question getNext() {
            if (this.value == "No") {
                return RuntimeTestExecuteInterview.this.qJMX;
            }
            if (this.value == "Yes") {
                return RuntimeTestExecuteInterview.this.qJVMTILivePhaseLauncherImpl;
            }
            return null;
        }

        public void export(Map map) {
            if (this.value == "Yes") {
                map.put("platform.jvmtiLivePhaseSupported", "true");
            } else {
                map.put("platform.jvmtiLivePhaseSupported", "false");
            }
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private final String jvmtiLivePhaseClsTemplate = "javasoft.sqe.jck.lib.attach.JVMTIAttachConnector";
    private JCKStringQuestion qJVMTILivePhaseLauncherImpl = new JCKStringQuestion(this, "jvmtiLivePhaseLauncherImpl"){
        {
            this.setSuggestions(new String[]{"", "javasoft.sqe.jck.lib.attach.JVMTIAttachConnector"});
        }

        protected Question getNext() {
            if (this.value == null || "".equals(this.value)) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qJMX;
        }

        public void export(Map map) {
            map.put("jvmtiLivePhaseLauncherImpl", this.value);
            map.put("nativeAgentLibName", "jckjvmti");
            map.put("nativeAgentLibOptsTempl", "${jvmtiTestName}");
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "javasoft.sqe.jck.lib.attach.JVMTIAttachConnector";
        }
    };
    private FileQuestion qJVMTILibPathFileValue = new FileQuestion(this, "jvmtiLibPathFileValue"){
        {
            this.setFilter(new DirectoryFileFilter("Directory containing native library for JVMTI tests"));
        }

        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled() && !this.value.isDirectory()) {
                return ((RuntimeTestExecuteInterview)RuntimeTestExecuteInterview.this).parent.qNoDirectoryError;
            }
            return RuntimeTestExecuteInterview.this.qJVMTILivePhase;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item = null;
            Checklist.Item[] itemArray = new Checklist.Item[2];
            File file = null;
            if (this.value != null && this.value.getPath().length() > 0) {
                file = this.value;
                itemArray[0] = item = RuntimeTestExecuteInterview.this.createChecklistItem("jvmtiSection", "jvmtiCompile");
                itemArray[1] = item = RuntimeTestExecuteInterview.this.createChecklistItem("jvmtiSection", "jvmtiLibrary", file);
            }
            return itemArray;
        }
    };
    private StringQuestion qJVMTILibPathValue = new StringQuestion(this, "jvmtiLibPathValue"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qJVMTILivePhase;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item = null;
            Checklist.Item[] itemArray = new Checklist.Item[2];
            String string = this.value;
            itemArray[0] = item = RuntimeTestExecuteInterview.this.createChecklistItem("jvmtiSection", "jvmtiCompile");
            itemArray[1] = item = RuntimeTestExecuteInterview.this.createChecklistItem("jvmtiSection", "jvmtiLibrary", string);
            return itemArray;
        }
    };
    private TestArgsQuestion qJMX = new TestArgsQuestion("jmx"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isMultiJVM()) {
                return this.getNext(RuntimeTestExecuteInterview.this.qLibPath, RuntimeTestExecuteInterview.this.doJNI() ? RuntimeTestExecuteInterview.this.qLibPath : RuntimeTestExecuteInterview.this.qRMI);
            }
            return this.getNext(RuntimeTestExecuteInterview.this.qJMXResourcePathValue, RuntimeTestExecuteInterview.this.qEnd);
        }

        String[] getTestURL() {
            return new String[]{"api/javax_management"};
        }
    };
    private ChoiceQuestion qLibPath = new ChoiceQuestion(this, "libPath"){
        {
            this.setChoices(new String[]{null, "environment variable", "command line option"});
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "environment variable") {
                return RuntimeTestExecuteInterview.this.qLibPathEnv;
            }
            return RuntimeTestExecuteInterview.this.qLibPathOpt;
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "environment variable";
        }
    };
    private StringQuestion qLibPathEnv = new StringQuestion(this, "libPathEnv"){
        {
            this.setSuggestions(new String[]{"", "LD_LIBRARY_PATH", "PATH"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (RuntimeTestExecuteInterview.this.oneNativeLibrariesLocation()) {
                if (RuntimeTestExecuteInterview.this.doJMX() && testPlatformInterview.isLocal()) {
                    return RuntimeTestExecuteInterview.this.qJMXResourcePathFileValue;
                }
                if (RuntimeTestExecuteInterview.this.doJMX() && !testPlatformInterview.isLocal()) {
                    return RuntimeTestExecuteInterview.this.qJMXResourcePathValue;
                }
                return RuntimeTestExecuteInterview.this.qRMI;
            }
            if (testPlatformInterview.isLocal()) {
                if (!RuntimeTestExecuteInterview.this.doJNI()) {
                    return RuntimeTestExecuteInterview.this.qJMXLibPathFileValue;
                }
                return RuntimeTestExecuteInterview.this.qJNILibPathFileValue;
            }
            if (!RuntimeTestExecuteInterview.this.doJNI()) {
                return RuntimeTestExecuteInterview.this.qJMXLibPathValue;
            }
            return RuntimeTestExecuteInterview.this.qJNILibPathValue;
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            String string = testPlatformInterview.getOS();
            if (EnvironmentInterview.isWindows(string)) {
                return this.getSuggestions()[2];
            }
            return this.getSuggestions()[1];
        }
    };
    private StringQuestion qLibPathOpt = new StringQuestion(this, "libPathOpt"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (RuntimeTestExecuteInterview.this.oneNativeLibrariesLocation()) {
                if (RuntimeTestExecuteInterview.this.doJMX() && testPlatformInterview.isLocal()) {
                    return RuntimeTestExecuteInterview.this.qJMXResourcePathFileValue;
                }
                if (RuntimeTestExecuteInterview.this.doJMX() && !testPlatformInterview.isLocal()) {
                    return RuntimeTestExecuteInterview.this.qJMXResourcePathValue;
                }
                return RuntimeTestExecuteInterview.this.qRMI;
            }
            if (testPlatformInterview.isLocal()) {
                if (!RuntimeTestExecuteInterview.this.doJNI()) {
                    return RuntimeTestExecuteInterview.this.qJMXLibPathFileValue;
                }
                return RuntimeTestExecuteInterview.this.qJNILibPathFileValue;
            }
            if (!RuntimeTestExecuteInterview.this.doJNI()) {
                return RuntimeTestExecuteInterview.this.qJMXLibPathValue;
            }
            return RuntimeTestExecuteInterview.this.qJNILibPathValue;
        }
    };
    private FileQuestion qNativeLibPathFileValue = new FileQuestion(this, "nativeLibPathFileValue"){
        {
            this.setFilter(new DirectoryFileFilter("Directory containing native libraries"));
        }

        protected Question getNext() {
            if (!this.isHidden()) {
                if (this.value == null || this.value.getPath().length() == 0) {
                    return null;
                }
                if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled() && !this.value.isDirectory()) {
                    return ((RuntimeTestExecuteInterview)RuntimeTestExecuteInterview.this).parent.qNoDirectoryError;
                }
            }
            return RuntimeTestExecuteInterview.this.qJNI;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item = null;
            Checklist.Item[] itemArray = null;
            File file = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.value != null && this.value.getPath().length() > 0) {
                file = this.value;
                itemArray = new Checklist.Item[2];
                if (RuntimeTestExecuteInterview.this.doJNI() || RuntimeTestExecuteInterview.this.doJMX() || RuntimeTestExecuteInterview.this.doJVMTI()) {
                    if (RuntimeTestExecuteInterview.this.doJNI()) {
                        stringBuffer = stringBuffer.append("JNI  ");
                    }
                    if (RuntimeTestExecuteInterview.this.doJMX()) {
                        stringBuffer = stringBuffer.append("JMX  ");
                    }
                    if (RuntimeTestExecuteInterview.this.doJVMTI()) {
                        stringBuffer = stringBuffer.append("JVMTI");
                    }
                    item = RuntimeTestExecuteInterview.this.createChecklistItem("nativeSection", "nativeLibsCompile", stringBuffer);
                } else {
                    item = RuntimeTestExecuteInterview.this.createChecklistItem("nativeSection", "nativeCompile");
                }
                itemArray[0] = item;
                itemArray[1] = item = RuntimeTestExecuteInterview.this.createChecklistItem("nativeSection", "nativeLibrary", file);
            }
            return itemArray;
        }

        public boolean isHidden() {
            return !RuntimeTestExecuteInterview.this.qJNI.matchTests() && !RuntimeTestExecuteInterview.this.qJMX.matchTests() && !RuntimeTestExecuteInterview.this.qJVMTI.matchTests();
        }

        public boolean isValueValid() {
            if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled()) {
                return super.isValueValid();
            }
            return true;
        }
    };
    private FileQuestion qJNILibPathFileValue = new FileQuestion(this, "jniLibPathFileValue"){
        {
            this.setFilter(new DirectoryFileFilter("Directory containing native library for JNI tests"));
        }

        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled() && !this.value.isDirectory()) {
                return ((RuntimeTestExecuteInterview)RuntimeTestExecuteInterview.this).parent.qNoDirectoryError;
            }
            if (RuntimeTestExecuteInterview.this.doJMX()) {
                return RuntimeTestExecuteInterview.this.qJMXLibPathFileValue;
            }
            return RuntimeTestExecuteInterview.this.qRMI;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item = null;
            Checklist.Item[] itemArray = null;
            File file = null;
            if (this.value != null && this.value.getPath().length() > 0) {
                file = this.value;
                item = RuntimeTestExecuteInterview.this.createChecklistItem("jniSection", "jniCompile");
                itemArray = new Checklist.Item[]{item, item = RuntimeTestExecuteInterview.this.createChecklistItem("jniSection", "jniLibrary", file)};
            }
            return itemArray;
        }

        public boolean isValueValid() {
            if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled()) {
                return super.isValueValid();
            }
            return true;
        }
    };
    private FileQuestion qJMXLibPathFileValue = new FileQuestion(this, "jmxLibPathFileValue"){
        {
            this.setFilter(new DirectoryFileFilter("Directory containing native library for JMX tests"));
        }

        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled() && !this.value.isDirectory()) {
                return ((RuntimeTestExecuteInterview)RuntimeTestExecuteInterview.this).parent.qNoDirectoryError;
            }
            return RuntimeTestExecuteInterview.this.qJMXResourcePathFileValue;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item = null;
            Checklist.Item[] itemArray = null;
            File file = null;
            if (this.value != null && this.value.getPath().length() > 0) {
                file = this.value;
                item = RuntimeTestExecuteInterview.this.createChecklistItem("jmxSection", "jmxCompile");
                itemArray = new Checklist.Item[]{item, item = RuntimeTestExecuteInterview.this.createChecklistItem("jmxSection", "jmxLibrary", file)};
            }
            return itemArray;
        }

        public boolean isValueValid() {
            if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled()) {
                return super.isValueValid();
            }
            return true;
        }
    };
    private JCKFileQuestion qJMXResourcePathFileValue = new JCKFileQuestion(this, "jmxResourcePathFileValue"){
        {
            this.setFilter(new DirectoryFileFilter("Directory containing HTML and jar files for JMX tests"));
        }

        public void export(Map map) {
            if (RuntimeTestExecuteInterview.this.doJMX() && this.value != null && this.value.getPath().length() > 0) {
                map.put("resource.JMXLibPath", Utils.adjust(this.value.getPath()));
            }
        }

        protected Question getNext() {
            if (!this.isHidden()) {
                if (this.value == null || this.value.getPath().length() == 0) {
                    return null;
                }
                if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled() && !this.value.isDirectory()) {
                    return ((RuntimeTestExecuteInterview)RuntimeTestExecuteInterview.this).parent.qNoDirectoryError;
                }
            }
            return RuntimeTestExecuteInterview.this.qRMI;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item[] itemArray = null;
            File file = null;
            if (this.value != null && this.value.getPath().length() > 0) {
                file = this.value;
                Checklist.Item item = RuntimeTestExecuteInterview.this.createChecklistItem("jmxSection", "jmxResource", file);
                itemArray = new Checklist.Item[]{item};
            }
            return itemArray;
        }

        public File[] getSuggestions() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl && !this.isHidden()) {
                return new File[]{this.getDefValue()};
            }
            return null;
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                return RuntimeTestExecuteInterview.this.qNativeLibPathFileValue.isHidden();
            }
            return super.isHidden();
        }

        private File getDefValue() {
            return RuntimeTestExecuteInterview.this.qNativeLibPathFileValue.getValue();
        }

        public boolean isValueValid() {
            if (RuntimeTestExecuteInterview.this.parent.getRootInterview().isErrorCheckingEnabled()) {
                return super.isValueValid();
            }
            return true;
        }
    };
    private StringQuestion qNativeLibPathValue = new StringQuestion(this, "nativeLibPathValue"){

        protected Question getNext() {
            if (!(this.isHidden() || this.value != null && this.value.length() != 0)) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qJNI;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item = null;
            Checklist.Item[] itemArray = new Checklist.Item[2];
            String string = this.value;
            StringBuffer stringBuffer = new StringBuffer();
            if (RuntimeTestExecuteInterview.this.doJNI() || RuntimeTestExecuteInterview.this.doJMX() || RuntimeTestExecuteInterview.this.doJVMTI()) {
                if (RuntimeTestExecuteInterview.this.doJNI()) {
                    stringBuffer = stringBuffer.append("JNI  ");
                }
                if (RuntimeTestExecuteInterview.this.doJMX()) {
                    stringBuffer = stringBuffer.append("JMX  ");
                }
                if (RuntimeTestExecuteInterview.this.doJVMTI()) {
                    stringBuffer = stringBuffer.append("JVMTI");
                }
                item = RuntimeTestExecuteInterview.this.createChecklistItem("nativeSection", "nativeLibsCompile", stringBuffer);
            } else {
                item = RuntimeTestExecuteInterview.this.createChecklistItem("nativeSection", "nativeCompile");
            }
            itemArray[0] = item;
            itemArray[1] = item = RuntimeTestExecuteInterview.this.createChecklistItem("nativeSection", "nativeLibrary", string);
            return itemArray;
        }

        public boolean isHidden() {
            return RuntimeTestExecuteInterview.this.qNativeLibPathFileValue.isHidden();
        }
    };
    private StringQuestion qJNILibPathValue = new StringQuestion(this, "jniLibPathValue"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (RuntimeTestExecuteInterview.this.doJMX()) {
                return RuntimeTestExecuteInterview.this.qJMXLibPathValue;
            }
            return RuntimeTestExecuteInterview.this.qRMI;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item = null;
            Checklist.Item[] itemArray = new Checklist.Item[2];
            String string = this.value;
            itemArray[0] = item = RuntimeTestExecuteInterview.this.createChecklistItem("jniSection", "jniCompile");
            itemArray[1] = item = RuntimeTestExecuteInterview.this.createChecklistItem("jniSection", "jniLibrary", string);
            return itemArray;
        }
    };
    private StringQuestion qJMXLibPathValue = new StringQuestion(this, "jmxLibPathValue"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qJMXResourcePathValue;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item = null;
            Checklist.Item[] itemArray = new Checklist.Item[2];
            String string = this.value;
            itemArray[0] = item = RuntimeTestExecuteInterview.this.createChecklistItem("jmxSection", "jmxCompile");
            itemArray[1] = item = RuntimeTestExecuteInterview.this.createChecklistItem("jmxSection", "jmxLibrary", string);
            return itemArray;
        }
    };
    private StringQuestion qJMXResourcePathValue = new StringQuestion(this, "jmxResourcePathValue"){

        protected void export(Map map) {
            if (RuntimeTestExecuteInterview.this.doJMX() && this.value != null && this.value.length() > 0) {
                map.put("resource.JMXLibPath", Utils.adjust(this.value));
            }
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isMultiJVM()) {
                return RuntimeTestExecuteInterview.this.qRMI;
            }
            return RuntimeTestExecuteInterview.this.qEnd;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item;
            Checklist.Item[] itemArray = new Checklist.Item[1];
            String string = this.value;
            itemArray[0] = item = RuntimeTestExecuteInterview.this.createChecklistItem("jmxSection", "jmxResource", string);
            return itemArray;
        }
    };
    private TestArgsQuestion qRMI = new TestArgsQuestion("rmi"){

        protected Question getNext() {
            return this.getNext(RuntimeTestExecuteInterview.this.qStdActivationPort, RuntimeTestExecuteInterview.this.qOptionSpecification);
        }

        String[] getTestURL() {
            return new String[]{"api/java_rmi", "api/javax_rmi"};
        }
    };
    private YesNoQuestion qStdActivationPort = new YesNoQuestion(this, "stdActivationPort"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeTestExecuteInterview.this.qRMIService;
            }
            return RuntimeTestExecuteInterview.this.qActivationPort;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item;
            Checklist.Item[] itemArray = new Checklist.Item[1];
            String string = this.value == "Yes" ? "the standard RMI activation port" : "port " + Integer.toString(RuntimeTestExecuteInterview.this.qActivationPortValue.getValue());
            itemArray[0] = item = RuntimeTestExecuteInterview.this.createChecklistItem("rmiSection", "rmiResource", string);
            return itemArray;
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }

        public void export(Map map) {
            if ("Yes".equals(this.value)) {
                map.put("rmid.port", String.valueOf(1098));
            }
        }
    };
    private ChoiceQuestion qActivationPort = new ChoiceQuestion(this, "activationPort"){
        {
            this.setChoices(new String[]{null, "environment variable", "command line option"});
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "environment variable") {
                return RuntimeTestExecuteInterview.this.qActivationPortEnv;
            }
            return RuntimeTestExecuteInterview.this.qActivationPortOpt;
        }
    };
    private StringQuestion qActivationPortEnv = new StringQuestion(this, "activationPortEnv"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qActivationPortValue;
        }
    };
    private StringQuestion qActivationPortOpt = new StringQuestion(this, "activationPortOpt"){
        {
            this.setSuggestions(new String[]{"", "-Djava.rmi.activation.port=#"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qActivationPortValue;
        }
    };
    private IntQuestion qActivationPortValue = new IntQuestion(this, "activationPortValue", 0, 65535){

        protected Question getNext() {
            if (this.isValid()) {
                return RuntimeTestExecuteInterview.this.qRMIService;
            }
            return null;
        }

        protected void export(Map map) {
            map.put("rmid.port", Integer.toString(this.getValue()));
        }
    };
    private StringQuestion qRMIService = new StringQuestion(this, "rmiService"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            ServicesInterview servicesInterview = RuntimeTestExecuteInterview.this.parent.getServicesInterview();
            if (RuntimeTestExecuteInterview.this.qRMIServiceLocal.isHidden() && RuntimeTestExecuteInterview.this.qRMIServiceRemote.isHidden()) {
                return RuntimeTestExecuteInterview.this.qOptionSpecification;
            }
            if (testPlatformInterview.isLocal()) {
                return RuntimeTestExecuteInterview.this.qRMIServiceLocal;
            }
            return RuntimeTestExecuteInterview.this.qRMIServiceRemote;
        }

        public boolean isEnabled() {
            return false;
        }
    };
    private StringQuestion qRMIServiceLocal = new RMIServiceQuestion(this, "rmiServiceLocal");
    private StringQuestion qRMIServiceRemote = new RMIServiceQuestion(this, "rmiServiceRemote");
    private YesNoQuestion qOptionSpecification = new YesNoQuestion(this, "optionSpecification"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qOSEnv();
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private TestArgsQuestion qAWT = new TestArgsQuestion("awt"){

        protected Question getNext() {
            return this.getNext(RuntimeTestExecuteInterview.this.qDISPLAY, RuntimeTestExecuteInterview.this.qOtherEnvVars);
        }

        public boolean isHidden() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isHeadless()) {
                this.setValue("No");
                return true;
            }
            return super.isHidden();
        }

        String[] getTestURL() {
            return new String[]{"api/java_applet", "api/java_awt", "api/java_beans", "api/java_io/interactive", "api/java_util/EventObject/serial", "api/javax_accessibility/AccessibleContext", "api/javax_naming/spi", "api/javax_print/interactive", "api/javax_sound/interactive", "api/javax_swing"};
        }
    };
    private StringQuestion qDISPLAY = new StringQuestion(this, "display"){

        public String[] getSuggestions() {
            String[] stringArray = super.getSuggestions();
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (stringArray == null && testPlatformInterview.isLocal()) {
                stringArray = this.getDefValues();
                this.setSuggestions(stringArray);
            }
            return stringArray;
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qOtherEnvVars;
        }

        public boolean isHidden() {
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isHeadless()) {
                return true;
            }
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValues()[0]);
            }
            return bl;
        }

        private String[] getDefValues() {
            String string;
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (!testPlatformInterview.isLocal()) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                string = System.getenv("DISPLAY");
                if (string != null && !string.equals("")) {
                    arrayList.add(string);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (Error error) {
                // empty catch block
            }
            if (arrayList.isEmpty()) {
                string = RuntimeNetworkInterview.getLocalhostName();
                arrayList.add(string + ":0.0");
            }
            return arrayList.toArray(new String[0]);
        }
    };
    private StringQuestion qSystemRoot = new StringQuestion(this, "systemRoot"){

        public String[] getSuggestions() {
            String[] stringArray = super.getSuggestions();
            if (stringArray == null) {
                stringArray = this.getDefValues();
                this.setSuggestions(stringArray);
            }
            return stringArray;
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qOtherEnvVars;
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                String[] stringArray = this.getDefValues();
                if (stringArray.length != 1) {
                    return super.isHidden();
                }
                this.setValue(this.getDefValues()[0]);
            }
            return bl;
        }

        private String[] getDefValues() {
            ArrayList<String> arrayList = new ArrayList<String>();
            TestPlatformInterview testPlatformInterview = RuntimeTestExecuteInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isLocal()) {
                try {
                    String string = System.getenv("SystemRoot");
                    if (string != null && !string.equals("")) {
                        arrayList.add(string);
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            if (arrayList.isEmpty()) {
                arrayList.add("");
                arrayList.add("C:\\Windows");
            }
            return arrayList.toArray(new String[0]);
        }
    };
    StringQuestion qOtherEnvVars = new StringQuestion(this, "otherEnvVars"){
        {
            this.setDefaultValue("");
        }

        protected Question getNext() {
            return RuntimeTestExecuteInterview.this.qVerify;
        }
    };
    private StringQuestion qVerify = new StringQuestion(this, "verify"){
        {
            this.setDefaultValue("");
            this.setSuggestions(new String[]{"", "/v", "-verify", "-Xfuture"});
        }

        protected Question getNext() {
            return RuntimeTestExecuteInterview.this.qOtherOpts;
        }

        public boolean isHidden() {
            boolean bl = RuntimeTestExecuteInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[3];
        }
    };
    private StringQuestion qOtherOpts = new StringQuestion(this, "otherOpts"){
        {
            this.setDefaultValue("");
        }

        protected Question getNext() {
            return RuntimeTestExecuteInterview.this.qEnd;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview parent;

    RuntimeTestExecuteInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "testExecute");
        this.parent = runtimeInterview;
        this.groupModeSupport = new GroupModeSupport(this);
        this.setFirstQuestion(this.qIntro);
    }

    public void export(Map map) {
        if (this.parent.isSimple()) {
            JCKExportedQuestion[] jCKExportedQuestionArray = new JCKExportedQuestion[]{this.qJarExecution, this.qJarExecutionOpt, this.qJVMTIOptTempl, this.qJVMTILivePhase, this.qJVMTILivePhaseLauncherImpl, this.qJMXResourcePathFileValue};
            for (int i = 0; i < jCKExportedQuestionArray.length; ++i) {
                JCKExportedQuestion jCKExportedQuestion = jCKExportedQuestionArray[i];
                if (!jCKExportedQuestion.isHidden()) continue;
                jCKExportedQuestion.export(map);
            }
        }
    }

    void exportForAdvancedMode(Map map) {
        this.qJarExecution.export(map);
    }

    private String getPathToJava(TestPlatformInterview testPlatformInterview) {
        return testPlatformInterview.isLocal() ? Utils.adjust(this.qCmdAsFile.getValue().toString()) : Utils.adjust(this.qCmdAsString.getValue());
    }

    public File getJavaHome() {
        if (this.qCmdAsFile.isValueValid()) {
            File file = this.qCmdAsFile.getValue();
            try {
                return file.getParentFile().getParentFile();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    private Question qAfterJarExecutionOpt() {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        if (testPlatformInterview.isMultiJVM()) {
            if (testPlatformInterview.isNativeCodeSupported()) {
                return this.qNativeLibrariesLocation;
            }
            return this.qRMI;
        }
        if (testPlatformInterview.isNativeCodeSupported()) {
            if (testPlatformInterview.isJVMTISupported()) {
                return this.qJVMTI;
            }
            return this.qJMX;
        }
        return this.qEnd;
    }

    private boolean oneNativeLibrariesLocation() {
        return this.qNativeLibrariesLocation.getValue() == "Yes";
    }

    private boolean doJNI() {
        return this.qJNI.getValue() == "Yes";
    }

    private boolean doJVMTI() {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        return this.qJVMTI.getValue() == "Yes" && testPlatformInterview.isJVMTISupported();
    }

    boolean isJVMTILivePhaseSupported() {
        return this.qJVMTILivePhase.getValue() == "Yes" && this.doJVMTI();
    }

    private boolean doJMX() {
        return this.qJMX.getValue() == "Yes";
    }

    boolean doRMI() {
        return this.qRMI.getValue() == "Yes";
    }

    private Question qOSEnv() {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        String string = testPlatformInterview.getOS();
        if (EnvironmentInterview.isWindows(string)) {
            return this.qSystemRoot;
        }
        if (testPlatformInterview.isXWindows()) {
            return this.qAWT;
        }
        return this.qOtherEnvVars;
    }

    boolean doAWT() {
        if (this.parent.isHeadless()) {
            return false;
        }
        return this.qAWT.getValue() == "Yes";
    }

    private void appendLoadImpl(StringBuffer stringBuffer) {
        String string = this.getAdditionalClasspath();
        if (string != null) {
            stringBuffer.append("-loadImpl").append(' ').append(string).append(' ');
        }
    }

    private String getAgentSameJVMCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        this.parent.appendAgentCommandPrefix(stringBuffer);
        stringBuffer.append("com.sun.jck.lib.ExecJCKTestSameJVMCmd");
        stringBuffer.append(' ');
        String string = System.getProperty("jck.classLoaderMode");
        if (string != null && string.equals("old") && this.qCreateClassLoaders.getValue() == "Yes") {
            stringBuffer.append("-loadDir");
            stringBuffer.append(' ');
            stringBuffer.append("$testSuiteRootDir/classes");
            stringBuffer.append(' ');
            this.appendLoadImpl(stringBuffer);
        }
        stringBuffer.append("$testExecuteClass $testExecuteArgs");
        return stringBuffer.toString();
    }

    private String getAgentSameJVMSeparateCLCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        this.parent.appendAgentCommandPrefix(stringBuffer);
        stringBuffer.append("com.sun.jck.lib.ExecJCKTestSameJVMCmd");
        stringBuffer.append(' ');
        stringBuffer.append("-loadDir");
        stringBuffer.append(' ');
        stringBuffer.append("$testSuiteRootDir/classes");
        stringBuffer.append(' ');
        this.appendLoadImpl(stringBuffer);
        stringBuffer.append("$testExecuteClass $testExecuteArgs");
        return stringBuffer.toString();
    }

    private String getAgentOtherJVMCommand(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.parent.appendAgentCommandPrefix(stringBuffer);
        this.appendOtherJVMCommand(stringBuffer, bl, bl2);
        return stringBuffer.toString();
    }

    private String getOtherJVMCommand(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendOtherJVMCommand(stringBuffer, bl, bl2);
        return stringBuffer.toString();
    }

    private String getAdditionalClasspath() {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        char c = testPlatformInterview.getPathSep();
        File[] fileArray = this.qAdditionalClasspath.getValue();
        String string = Utils.constructClasspath(fileArray, c);
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return null;
    }

    private void appendOtherJVMCommand(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        String string;
        String string2;
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        char c = testPlatformInterview.getFileSep();
        char c2 = testPlatformInterview.getPathSep();
        String string3 = this.parent.getTestClassPath();
        String string4 = this.getAdditionalClasspath();
        if (bl) {
            this.groupModeSupport.appendArguments(stringBuffer);
            string3 = "$testSuiteRootDir" + c + "lib" + c + "javatest.jar" + c2 + "$testSuiteRootDir" + c + "lib" + c + "jtjck.jar";
        } else {
            stringBuffer.append("com.sun.jck.lib.ExecJCKTestOtherJVMCmd ");
        }
        if (string4 != null) {
            string3 = string3 + c2 + string4;
        }
        int n = stringBuffer.length();
        if (!bl2 && this.qClassPath.getValue() == "environment variable") {
            stringBuffer.append(this.qClassPathEnv.getValue());
            stringBuffer.append('=');
            stringBuffer.append(string3);
            stringBuffer.append(' ');
        }
        if (testPlatformInterview.isNativeCodeSupported() && (this.doJNI() || this.doJMX() || this.doJVMTI()) && this.qLibPath.getValue() == "environment variable") {
            string2 = null;
            stringBuffer.append(this.qLibPathEnv.getValue());
            stringBuffer.append('=');
            if (this.oneNativeLibrariesLocation()) {
                string2 = testPlatformInterview.isLocal() ? Utils.adjust(this.qNativeLibPathFileValue.getValue().getPath()) : Utils.adjust(this.qNativeLibPathValue.getValue());
            } else {
                if (this.doJNI() && this.doJMX()) {
                    string2 = testPlatformInterview.isLocal() ? Utils.adjust(this.qJNILibPathFileValue.getValue().getPath()) + c2 + Utils.adjust(this.qJMXLibPathFileValue.getValue().getPath()) : Utils.adjust(this.qJNILibPathValue.getValue()) + c2 + Utils.adjust(this.qJMXLibPathValue.getValue());
                } else if (this.doJNI()) {
                    string2 = testPlatformInterview.isLocal() ? Utils.adjust(this.qJNILibPathFileValue.getValue().getPath()) : Utils.adjust(this.qJNILibPathValue.getValue());
                } else if (this.doJMX()) {
                    String string5 = string2 = testPlatformInterview.isLocal() ? Utils.adjust(this.qJMXLibPathFileValue.getValue().getPath()) : Utils.adjust(this.qJMXLibPathValue.getValue());
                }
                if (this.doJVMTI()) {
                    string2 = (string2 == null ? "" : string2 + c2) + (testPlatformInterview.isLocal() ? Utils.adjust(this.qJVMTILibPathFileValue.getValue().getPath()) : Utils.adjust(this.qJVMTILibPathValue.getValue()));
                }
            }
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        if (this.qRMI.getValue() == "Yes" && this.qStdActivationPort.getValue() != "Yes" && this.qActivationPort.getValue() == "environment variable") {
            stringBuffer.append(this.qActivationPortEnv.getValue());
            stringBuffer.append('=');
            stringBuffer.append(String.valueOf(this.qActivationPortValue.getValue()));
            stringBuffer.append(' ');
        }
        string2 = testPlatformInterview.getOS();
        if (testPlatformInterview.isXWindows()) {
            if (this.doAWT()) {
                stringBuffer.append("DISPLAY=");
                stringBuffer.append(this.qDISPLAY.getValue());
                stringBuffer.append(' ');
                stringBuffer.append("HOME=${user.home}");
                stringBuffer.append(' ');
            }
        } else if (EnvironmentInterview.isWindows(string2)) {
            String[] stringArray;
            string = this.qSystemRoot.getValue();
            stringBuffer.append("SystemRoot=");
            stringBuffer.append(string);
            stringBuffer.append(' ');
            String string6 = this.qOtherEnvVars.getValue();
            if (string6 != null && !string6.toLowerCase().contains("systemdrive=")) {
                stringArray = string.split(":");
                stringBuffer.append("SystemDrive=");
                stringBuffer.append(stringArray[0]);
                stringBuffer.append(": ");
            }
            stringArray = Utils.adjust(this.parent.getRootInterview().getWorkDirectory().getPath());
            stringBuffer.append("TMP=");
            stringBuffer.append((String)stringArray);
            stringBuffer.append(' ');
            stringBuffer.append("TEMP=");
            stringBuffer.append((String)stringArray);
            stringBuffer.append(' ');
        }
        Utils.appendValue(stringBuffer, this.qOtherEnvVars.getValue());
        if (bl) {
            if (n < stringBuffer.length()) {
                stringBuffer.insert(n, "-MENV_ ");
            }
            stringBuffer.append("-MCMD_ ");
        }
        stringBuffer.append(this.getPathToJava(testPlatformInterview));
        stringBuffer.append(' ');
        stringBuffer.append(this.qOtherOpts.getValue());
        stringBuffer.append(' ');
        stringBuffer.append("${jvmtiAgentOptions}");
        stringBuffer.append(' ');
        stringBuffer.append(this.qVerify.getValue());
        stringBuffer.append(' ');
        stringBuffer.append("$jdwpAgentOptions");
        stringBuffer.append(' ');
        if (!bl2 && this.qClassPath.getValue() == "command line option") {
            stringBuffer.append(Utils.evalTemplate(this.qClassPathOpt.getValue(), string3));
            stringBuffer.append(' ');
        }
        if (testPlatformInterview.isNativeCodeSupported() && (this.doJNI() || this.doJMX() || this.doJVMTI()) && this.qLibPath.getValue() == "command line option") {
            string = null;
            if (this.oneNativeLibrariesLocation()) {
                string = testPlatformInterview.isLocal() ? Utils.adjust(this.qNativeLibPathFileValue.getValue().getPath()) : Utils.adjust(this.qNativeLibPathValue.getValue());
            } else {
                if (this.doJNI() && this.doJMX()) {
                    string = testPlatformInterview.isLocal() ? Utils.adjust(this.qJNILibPathFileValue.getValue().getPath()) + c2 + Utils.adjust(this.qJMXLibPathFileValue.getValue().getPath()) : Utils.adjust(this.qJNILibPathValue.getValue()) + c2 + Utils.adjust(this.qJMXLibPathValue.getValue());
                } else if (this.doJNI()) {
                    string = testPlatformInterview.isLocal() ? Utils.adjust(this.qJNILibPathFileValue.getValue().getPath()) : Utils.adjust(this.qJNILibPathValue.getValue());
                } else if (this.doJMX()) {
                    String string7 = string = testPlatformInterview.isLocal() ? Utils.adjust(this.qJMXLibPathFileValue.getValue().getPath()) : Utils.adjust(this.qJMXLibPathValue.getValue());
                }
                if (this.doJVMTI()) {
                    string = (string == null ? "" : string + c2) + (testPlatformInterview.isLocal() ? Utils.adjust(this.qJVMTILibPathFileValue.getValue().getPath()) : Utils.adjust(this.qJVMTILibPathValue.getValue()));
                }
            }
            stringBuffer.append(Utils.evalTemplate(this.qLibPathOpt.getValue(), string));
            stringBuffer.append(' ');
        }
        stringBuffer.append("$JPLISAgentOpts");
        stringBuffer.append(' ');
        stringBuffer.append("$JPLISAgent2Opts");
        stringBuffer.append(' ');
        stringBuffer.append("$jvmArgSplashOpt");
        stringBuffer.append(' ');
        if (this.qOptionSpecification.getValue() == "Yes") {
            stringBuffer.append("-Djava.security.policy=$testSuiteRootDir" + c + "lib" + c + "jck.policy ");
        }
        if (this.doRMI() && this.qStdActivationPort.getValue() != "Yes" && this.qActivationPort.getValue() == "command line option") {
            stringBuffer.append(Utils.evalTemplate(this.qActivationPortOpt.getValue(), String.valueOf(this.qActivationPortValue.getValue())));
            stringBuffer.append(' ');
        }
        if (bl) {
            stringBuffer.append("-MTEST_ com.sun.jck.lib.ExecJCKTestSameJVMCmd ");
            stringBuffer.append("-loadDir $testSuiteRootDir" + c + "classes ");
            this.appendLoadImpl(stringBuffer);
        }
        if (!bl2) {
            stringBuffer.append("$testExecuteClass");
            stringBuffer.append(' ');
        } else {
            stringBuffer.append("$jvmArgJarOpt");
            stringBuffer.append(' ');
        }
        stringBuffer.append("$testExecuteArgs");
    }

    private class RMIServiceQuestion
    extends StringQuestion {
        public RMIServiceQuestion(Interview interview, String string) {
            super(interview, string);
            String string2 = String.format("%1$s/bin/rmid -port %2$s", "@{java.home}", "@{port}");
            this.setSuggestions(new String[]{"", string2});
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeTestExecuteInterview.this.qOptionSpecification;
        }

        public void export(Map map) {
            if (this.getValue() == null) {
                return;
            }
            String string = Utils.adjustForSpace(this.getValue());
            map.put("service.rmi.command", string);
        }

        public boolean isHidden() {
            ServicesInterview servicesInterview = RuntimeTestExecuteInterview.this.parent.getServicesInterview();
            if (!servicesInterview.areServicesOn()) {
                return true;
            }
            return !servicesInterview.needRmid();
        }
    }

    private abstract class TestArgsQuestion
    extends SwitchInterviewQuestion
    implements JCKExportedQuestion {
        TestArgsQuestion(String string) {
            super(RuntimeTestExecuteInterview.this, string);
        }

        protected final Question getNext(Question question, Question question2) {
            if (this.showNestedInterview()) {
                return question;
            }
            if (this.value == "No") {
                return question2;
            }
            return null;
        }

        public void export(Map map) {
            super.export(map);
        }

        JCKParameters getJCKParametersInterview() {
            return RuntimeTestExecuteInterview.this.parent.getRootInterview();
        }
    }
}

