/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.TestSuite;
import com.sun.jck.interview.JCKChoiceQuestion;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Map;

class RuntimeJSSEInterview
extends JCKEnvInterview {
    static final String YES = "Yes";
    static final String NO = "No";
    static final String YES_CHOICE = "JKS Keystore Format";
    static final String NO_CHOICE = "Other Keystore Format";
    private JCKChoiceQuestion qJKSSupported = new JCKChoiceQuestion(this, "isJKSSupported"){
        {
            this.setChoices(new String[]{RuntimeJSSEInterview.YES, RuntimeJSSEInterview.NO}, new String[]{RuntimeJSSEInterview.YES_CHOICE, RuntimeJSSEInterview.NO_CHOICE});
        }

        protected Question getNext() {
            if (this.value == RuntimeJSSEInterview.YES) {
                return RuntimeJSSEInterview.this.qEnd;
            }
            if (this.value == RuntimeJSSEInterview.NO) {
                return RuntimeJSSEInterview.this.qInfo;
            }
            return null;
        }

        public void export(Map map) {
            if (this.value == RuntimeJSSEInterview.YES) {
                map.put("platform.isJKSSupported", "yes");
                map.put("platform.keyStoreType", RuntimeJSSEInterview.JKSProp);
                map.put("platform.keyStorePassword", "DukesSecretPassword");
                map.put("platform.keyAlgorithm", RuntimeJSSEInterview.RSAProp);
                map.put("platform.keyIssuer", Utils.encode("CN=Roger Pham, OU=\"Sun Microsystems, Inc.\", O=JavaSoft, L=Santa Clara Campus SCA-22, ST=CA, C=US"));
                map.put("platform.keyPassword", "DukesSecretPassword");
                TestSuite testSuite = RuntimeJSSEInterview.this.parent.getRootInterview().getTestSuite();
                File file = null;
                try {
                    File file2 = file = testSuite == null ? null : new File(testSuite.getRootDir().getPath() + "/tests/api/javax_net/ssl/keystore/testkeys.jks".replace('/', File.separatorChar));
                    if (file != null) {
                        map.put("platform.keyStoreURL", file.toURI().toURL().toString());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                map.put("platform.isJKSSupported", "no");
            }
        }

        public boolean isHidden() {
            boolean bl = RuntimeJSSEInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return RuntimeJSSEInterview.YES;
        }
    };
    private NullQuestion qInfo = new NullQuestion(this, "supportedKeyStoreInfo"){

        protected Question getNext() {
            return RuntimeJSSEInterview.this.qKeyStoreType;
        }
    };
    static final String PKCS12Prop = "PKCS12";
    static final String JKSProp = "JKS";
    private StringQuestion qKeyStoreType = new StringQuestion(this, "keyStoreType"){
        {
            this.setSuggestions(new String[]{"", RuntimeJSSEInterview.PKCS12Prop, RuntimeJSSEInterview.JKSProp});
        }

        protected void export(Map map) {
            map.put("platform.keyStoreType", this.value);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            TestPlatformInterview testPlatformInterview = RuntimeJSSEInterview.this.parent.getTestPlatformInterview();
            if (testPlatformInterview.isLocal()) {
                return RuntimeJSSEInterview.this.qKeyStoreFile;
            }
            return RuntimeJSSEInterview.this.qKeyStoreFileAsString;
        }
    };
    private FileQuestion qKeyStoreFile = new FileQuestion(this, "keyStoreFile"){

        protected Question getNext() {
            try {
                if (RuntimeJSSEInterview.this.parent.getRootInterview().isErrorCheckingEnabled() && !this.value.isFile()) {
                    return ((RuntimeJSSEInterview)RuntimeJSSEInterview.this).parent.qNoFileError;
                }
            }
            catch (SecurityException securityException) {
                return null;
            }
            return RuntimeJSSEInterview.this.qKeyStorePassword;
        }

        protected void export(Map map) {
            try {
                map.put("platform.keyStoreURL", this.value.toURI().toURL().toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public boolean isValueValid() {
            return this.value != null && this.value.getPath().length() > 0;
        }
    };
    private StringQuestion qKeyStoreFileAsString = new StringQuestion(this, "keyStoreFileAsString"){

        protected void export(Map map) {
            map.put("platform.keyStoreURL", this.value);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeJSSEInterview.this.qKeyStorePassword;
        }
    };
    private StringQuestion qKeyStorePassword = new StringQuestion(this, "keyStorePassword"){

        protected void export(Map map) {
            map.put("platform.keyStorePassword", this.value);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeJSSEInterview.this.qKeyAlgorithm;
        }
    };
    static final String RSAProp = "RSA";
    static final String DSAProp = "DSA";
    private StringQuestion qKeyAlgorithm = new StringQuestion(this, "keyAlgorithm"){
        {
            this.setSuggestions(new String[]{"", RuntimeJSSEInterview.RSAProp, RuntimeJSSEInterview.DSAProp});
        }

        protected void export(Map map) {
            map.put("platform.keyAlgorithm", this.value);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeJSSEInterview.this.qKeyIssuer;
        }
    };
    private StringQuestion qKeyIssuer = new StringQuestion(this, "keyIssuer"){
        {
            this.setSuggestions(new String[]{"", "CN=Mark Smith, OU=Java, O=Sun, L=Cupertino, S=California, C=US"});
        }

        protected void export(Map map) {
            map.put("platform.keyIssuer", Utils.encode(this.value));
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeJSSEInterview.this.qKeyPassword;
        }
    };
    private StringQuestion qKeyPassword = new StringQuestion(this, "keyPassword"){

        protected void export(Map map) {
            map.put("platform.keyPassword", this.value);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeJSSEInterview.this.qEnd;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview parent;

    RuntimeJSSEInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "jsse");
        this.parent = runtimeInterview;
        this.setFirstQuestion(this.qJKSSupported);
    }

    public void export(Map map) {
        super.export(map);
        if (this.parent.isSimple() && this.qJKSSupported.isHidden()) {
            this.qJKSSupported.export(map);
        }
    }
}

