/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.Checklist;
import com.sun.interview.ChoiceQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.ProductInterview;
import com.sun.jck.interview.ServicesInterview;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.util.Map;

class AgentInterview
extends JCKEnvInterview {
    static final String ACTIVE = "active";
    static final String PASSIVE = "passive";
    private ChoiceQuestion qAgentType = new ChoiceQuestion(this, "agentType"){
        {
            this.setChoices(new String[]{null, AgentInterview.ACTIVE, AgentInterview.PASSIVE});
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == AgentInterview.ACTIVE) {
                return AgentInterview.this.qServicesIntro;
            }
            return AgentInterview.this.qPassiveHost;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item[] itemArray = new Checklist.Item[2];
            String string = this.value == AgentInterview.ACTIVE ? AgentInterview.ACTIVE : AgentInterview.PASSIVE;
            Checklist.Item item = AgentInterview.this.createChecklistItem("agentSection", "agentResource1");
            Checklist.Item item2 = AgentInterview.this.createChecklistItem("agentSection", "agentResource2", string);
            itemArray[0] = item;
            itemArray[1] = item2;
            return itemArray;
        }

        public void export(Map map) {
            if (this.value == null) {
                return;
            }
            map.put("agent.type", this.value);
        }
    };
    private StringQuestion qPassiveHost = new StringQuestion(this, "passiveHost"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return AgentInterview.this.qPassivePortDefault;
        }

        public void export(Map map) {
            if (this.getValue() == null) {
                return;
            }
            String string = Utils.adjustForSpace(this.getValue());
            map.put("agent.hosts", string);
        }
    };
    private YesNoQuestion qPassivePortDefault = new YesNoQuestion(this, "passivePortDefault"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return AgentInterview.this.qServicesIntro;
            }
            return AgentInterview.this.qPassivePort;
        }

        public void export(Map map) {
            map.put("passive.agent.port", String.valueOf(1908));
        }
    };
    private IntQuestion qPassivePort = new IntQuestion(this, "passivePort", 0, 65535){

        protected Question getNext() {
            if (!this.isValid()) {
                return null;
            }
            return AgentInterview.this.qServicesIntro;
        }

        public void export(Map map) {
            map.put("passive.agent.port", String.valueOf(this.value));
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private ProductInterview parent;
    private Question qServicesIntro = new NullQuestion(this, "servicesIntro"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = AgentInterview.this.parent.getTestPlatformInterview();
            ServicesInterview servicesInterview = AgentInterview.this.parent.getServicesInterview();
            if (!servicesInterview.areServicesOn()) {
                return AgentInterview.this.qEnd;
            }
            if (testPlatformInterview.isLocal()) {
                return AgentInterview.this.qEnd;
            }
            if (AgentInterview.PASSIVE.equals(AgentInterview.this.getAgentType())) {
                return AgentInterview.this.qPassiveServiceCommand;
            }
            return AgentInterview.this.qActiveHosts;
        }

        public boolean isHidden() {
            return true;
        }
    };
    private Question qActiveHosts = new StringQuestion(this, "activeHosts"){

        protected Question getNext() {
            if (!(this.value != null && this.value.length() != 0 || this.isHidden())) {
                return null;
            }
            return AgentInterview.this.qActiveServiceCommand;
        }

        public boolean isHidden() {
            ServicesInterview servicesInterview = AgentInterview.this.parent.getServicesInterview();
            TestPlatformInterview testPlatformInterview = AgentInterview.this.parent.getTestPlatformInterview();
            if (AgentInterview.PASSIVE.equals(AgentInterview.this.getAgentType())) {
                return true;
            }
            return !servicesInterview.areServicesOn();
        }

        public void export(Map map) {
            if (this.getValue() == null) {
                return;
            }
            String string = Utils.adjustForSpace(this.getValue());
            map.put("agent.hosts", string);
        }
    };
    private StringQuestion qActiveServiceCommand = new StringQuestion(this, "activeServiceCommand"){
        {
            String string2 = String.format("%3$s/bin/java -cp %1$s/classes:%1$s/lib/javatest.jar  -Djava.security.policy=%1$s/lib/jck.policy  -Djava.rmi.activation.port=%4$s  -Djavatest.security.allowPropertiesAccess=true  com.sun.javatest.agent.AgentMain -active -activeHost %2$s", "@{testsuite}", "@{host}", "@{java.home}", "@{rmi.port}");
            this.setSuggestions(new String[]{"", string2});
        }

        public void export(Map map) {
            if (this.getValue() == null) {
                return;
            }
            String string = Utils.adjustForSpace(this.getValue());
            map.put("active.agent.service.command", string);
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return AgentInterview.this.qEnd;
        }

        public boolean isHidden() {
            TestPlatformInterview testPlatformInterview = AgentInterview.this.parent.getTestPlatformInterview();
            ServicesInterview servicesInterview = AgentInterview.this.parent.getServicesInterview();
            if (testPlatformInterview.isLocal()) {
                return true;
            }
            if (AgentInterview.PASSIVE.equals(AgentInterview.this.getAgentType())) {
                return true;
            }
            return !servicesInterview.areServicesOn();
        }
    };
    private StringQuestion qPassiveServiceCommand = new StringQuestion(this, "passiveServiceCommand"){
        {
            String string2 = String.format("%3$s/bin/java -cp %1$s/classes:%1$s/lib/javatest.jar  -Djava.security.policy=%1$s/lib/jck.policy  -Djava.rmi.activation.port=%4$s  -Djavatest.security.allowPropertiesAccess=true com.sun.javatest.agent.AgentMain -passive -passivePort %2$s", "@{testsuite}", "@{port}", "@{java.home}", "@{rmi.port}");
            this.setSuggestions(new String[]{"", string2});
        }

        public void export(Map map) {
            if (this.getValue() == null) {
                return;
            }
            String string = Utils.adjustForSpace(this.getValue());
            map.put("passive.agent.service.command", string);
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return AgentInterview.this.qEnd;
        }

        public boolean isHidden() {
            TestPlatformInterview testPlatformInterview = AgentInterview.this.parent.getTestPlatformInterview();
            ServicesInterview servicesInterview = AgentInterview.this.parent.getServicesInterview();
            if (testPlatformInterview.isLocal()) {
                return true;
            }
            if (AgentInterview.ACTIVE.equals(AgentInterview.this.getAgentType())) {
                return true;
            }
            return !servicesInterview.areServicesOn();
        }
    };

    AgentInterview(ProductInterview productInterview) {
        super(productInterview, "agent");
        this.parent = productInterview;
        this.setFirstQuestion(this.qAgentType);
    }

    void appendCommandPrefix(StringBuffer stringBuffer) {
        if (this.qAgentType.getValue() == ACTIVE) {
            stringBuffer.append("com.sun.javatest.agent.ActiveAgentCommand");
            stringBuffer.append(' ');
        } else {
            stringBuffer.append("com.sun.javatest.agent.PassiveAgentCommand");
            stringBuffer.append(' ');
            stringBuffer.append("-host");
            stringBuffer.append(' ');
            stringBuffer.append(this.qPassiveHost.getValue());
            stringBuffer.append(' ');
            if (this.qPassivePortDefault.getValue() == "No") {
                stringBuffer.append("-port");
                stringBuffer.append(' ');
                stringBuffer.append(this.qPassivePort.getValue());
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append("-mapArgs");
        stringBuffer.append(' ');
    }

    String getAgentType() {
        return this.qAgentType.getValue();
    }

    String getPassiveHost() {
        return this.qPassiveHost.getValue();
    }

    boolean passivePortDefault() {
        return "Yes".equals(this.qPassivePortDefault.getValue());
    }

    int getPassivePort() {
        return this.qPassivePort.getValue();
    }
}

