/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: DescriptorThreeTestBean.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.migration.threetwo;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.migration.threetwo.ThreeTestBeanBase;
import com.sun.ts.tests.ejb30.common.migration.threetwo.ThreeTestIF;
import com.sun.ts.tests.ejb30.common.migration.threetwo.TwoLocalHome;
import com.sun.ts.tests.ejb30.common.migration.threetwo.TwoRemoteHome;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;


//@Stateless(name="ThreeTestBean")
//@Remote(ThreeTestIF.class)
public class DescriptorThreeTestBean extends ThreeTestBeanBase implements ThreeTestIF {
    private static final String TWO_REMOTE_HOME_NAME = "java:comp/env/twoRemoteHome";
    private static final String TWO_LOCAL_HOME_NAME  = "java:comp/env/twoLocalHome";
    
//    @EJB(name="twoRemoteHome")
//    ejb-ref declared in descriptor, but not injected
    private TwoRemoteHome twoRemoteHome;
    
//    @EJB(name="twoLocalHome")
//    ejb-ref declared in descriptor, but not injected    
    private TwoLocalHome twoLocalHome;
    
//    @Resource
    private SessionContext sctx;
    
    public DescriptorThreeTestBean() {
    }
    
    public void remove() {
    }
    
    protected TwoRemoteHome getTwoRemoteHome() {
        if(twoRemoteHome == null) {
            try {
                Object obj = ServiceLocator.lookup(TWO_REMOTE_HOME_NAME);
                twoRemoteHome = (TwoRemoteHome) PortableRemoteObject.narrow(obj,
                    TwoRemoteHome.class);
            } catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
        return twoRemoteHome;
    }
    
    protected TwoLocalHome getTwoLocalHome() {
        if(twoLocalHome == null) {
            try {
                Object obj = ServiceLocator.lookup(TWO_LOCAL_HOME_NAME);
                twoLocalHome = (TwoLocalHome) PortableRemoteObject.narrow(obj,
                    TwoLocalHome.class);
            } catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
        return twoLocalHome;
    }
    
    protected javax.ejb.EJBContext getEJBContext() {
        return sctx;
    }
    
}
