/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServletBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.covariant;

import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.servlet.common.util.Data;
import java.io.IOException;
import java.io.PrintWriter;
import javax.ejb.EJB;
import javax.ejb.EJBTransactionRequiredException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TestServletBase extends HttpTCKServlet {
    @EJB(name="remoteFuzzyBean")
    private FuzzyRemoteIF remoteFuzzyBean;
    
    @EJB(name="localFuzzyBean")
    private FuzzyLocalIF localFuzzyBean;
    
    public void getMessage(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        boolean pass2 = false;
        StringBuilder reason = new StringBuilder();
        try {
            Object o = remoteFuzzyBean.getMessage();
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(remoteFuzzyBean).append(" getMessage() method");
        } catch (EJBTransactionRequiredException e) {
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(remoteFuzzyBean).append(" getMessage() method");
        }
        try {
            Object o = localFuzzyBean.getMessage();
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(localFuzzyBean).append(" getMessage() method");
        } catch (EJBTransactionRequiredException e) {
            pass2 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(localFuzzyBean).append(" getMessage() method");
        }
        pw.println((pass1 && pass2) ? Data.PASSED : Data.FAILED);
        pw.println(reason.toString());
    }
    
    public void getMessages(HttpServletRequest request, 
            HttpServletResponse response) 
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        boolean pass2 = false;
        StringBuilder reason = new StringBuilder();
        try {
            Object[] oo = remoteFuzzyBean.getMessages();
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(remoteFuzzyBean).append(" getMessages() method");
        } catch (EJBTransactionRequiredException e) {
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(remoteFuzzyBean).append(" getMessages() method");
        }
        try {
            Object o = localFuzzyBean.getMessages();
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(localFuzzyBean).append(" getMessages() method");
        } catch (EJBTransactionRequiredException e) {
            pass2 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(localFuzzyBean).append(" getMessages() method");
        }
        pw.println((pass1 && pass2) ? Data.PASSED : Data.FAILED);
        pw.println(reason.toString());
    }
    
    public void getNumbers(HttpServletRequest request, 
            HttpServletResponse response) 
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean pass1 = false;
        boolean pass2 = false;
        StringBuilder reason = new StringBuilder();
        try {
            Object[] oo = remoteFuzzyBean.getNumbers();
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(remoteFuzzyBean).append(" getNumbers() method");
        } catch (EJBTransactionRequiredException e) {
            pass1 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(remoteFuzzyBean).append(" getNumbers() method");
        }
        try {
            Object o = localFuzzyBean.getNumbers();
            reason.append("Failed to get expected EJBTransactionRequiredException when invoking .");
            reason.append(localFuzzyBean).append(" getNumbers() method");
        } catch (EJBTransactionRequiredException e) {
            pass2 = true;
            reason.append(" Got expected EJBTransactionRequiredException when invoking .");
            reason.append(localFuzzyBean).append(" getNumbers() method");
        }
        pw.println((pass1 && pass2) ? Data.PASSED : Data.FAILED);
        pw.println(reason.toString());
    }
}


