 /*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: MDBCallbackBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.callback;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.messaging.StatusReporter;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;

abstract public class MDBCallbackBeanBase extends CallbackBeanBase 
        implements MessageListener {
//    @Resource(name="qFactory")
//    private QueueConnectionFactory qFactory;
//    
//    @Resource(name="replyQueue")
//    private Queue replyQueue;
    
   //================== business methods ====================================
    public void onMessage(javax.jms.Message msg) {
        boolean status = false;
        String reason = null;
        String testname = null;
        try {
            testname = msg.getStringProperty(
                    com.sun.ts.tests.ejb30.common.messaging.Constants.TEST_NAME_KEY);
        } catch (javax.jms.JMSException e) {
            status = false;
            reason = "Failed to get test name from message: " + msg;
            TLogger.log(reason);
            StatusReporter.report(testname, status, reason, 
                    (QueueConnectionFactory) getEJBContext().lookup("qFactory"), 
                    (Queue) getEJBContext().lookup("replyQueue"));
            return;
        }
        if(testname.equals(isInjectionDoneTest)) {
            status = isInjectionDone();
            reason = "isInjectionDone() in onMessage returns: " + status;
        } else if(testname.equals(isPostConstructCalledTest)) {
            status = isPostConstructCalled();
            reason = "isPostConstructCalled() in onMessage returns: " + status;
        } else if(testname.equals(isPostConstructOrPreDestroyCalledTest)) {
            status = isPostConstructCalled() || isPreDestroyCalled();
            reason = "isPostConstructCalled() or isPreDestroyCalled() in onMessage returns: " + status;
        } else {
            status = false;
            reason = "Unrecognized test: " + testname;
        }
        TLogger.log(reason);
        StatusReporter.report(testname, status, reason, 
                    (QueueConnectionFactory) getEJBContext().lookup("qFactory"), 
                    (Queue) getEJBContext().lookup("replyQueue"));
    }
}
