/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: NoInterfaceRemoteCalculator.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.calc;

/**
 * A remote calculator class without implementing any interface. This is to
 * test a bean class without implementing any interface must have its business
 * interface generated. When @Remote is applied to such interfaceless bean
 * classes, the generated business interface must have remote accessibility.
 * 
 * @author Cheng Fang
 */
public class NoInterfaceRemoteCalculator {

    public NoInterfaceRemoteCalculator() {
    }

    public int remoteAdd(int a, int b) {
        return RemoteCalculator.EXTRA + a + b;
    }

    public int remoteSubtract(int a, int b) {
        return RemoteCalculator.EXTRA + a - b;
    }

    public void remoteThrowIt() throws CalculatorException {
        throw new CalculatorException();
    }

}
