/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Stateless3VehicleBean.java 63113 2011-06-20 11:18:36Z sdimilla $
 */

package com.sun.ts.tests.common.vehicle.stateless3;

import com.sun.ts.tests.common.vehicle.ejb3share.UserTransactionWrapper;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.*;
import javax.persistence.*;

@Stateless(name = "Stateless3VehicleBean")
@PersistenceContext(name = "STATELESS3EM", unitName = "CTS-EM")
@Remote({Stateless3VehicleIF.class})
@TransactionManagement(TransactionManagementType.BEAN)
public class Stateless3VehicleBean
        extends com.sun.ts.tests.common.vehicle.ejb3share.EJB3ShareBaseBean
        implements Stateless3VehicleIF {

    @PersistenceUnit(name = "STATELESS3EMF", unitName = "CTS-EM")
    EntityManagerFactory emf;

    public Stateless3VehicleBean() {
        super();
    }

    protected String getVehicleType() {
        return STATELESS3;
    }

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @PostConstruct
    public void init() {
        try {
            System.out.println("In PostContruct");
            EntityManager entityManager = (EntityManager)
                    sessionContext.lookup("STATELESS3EM");
            EntityManagerFactory emf = (EntityManagerFactory)
                    sessionContext.lookup("STATELESS3EMF");
            setEntityManager(entityManager);
            setEntityManagerFactory(emf);
        } catch (Exception e) {
            System.out.println("ERROR: " +
                    " In PostConstruct: Exception caught while setting EntityManager");
            e.printStackTrace();
        }
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    protected EntityTransaction getEntityTransaction() {
        return new UserTransactionWrapper(sessionContext.getUserTransaction());
    }
}
