/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.entityManager;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.EntityManager;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TransactionRequiredException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Client
extends PMClientBase {
    Properties props = null;
    Map map = new HashMap();

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void createEntityManagerSynchronizationTypeMapTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Test UNSYNCHRONIZED");
            EntityManager em1 = this.getEntityManagerFactory().createEntityManager(SynchronizationType.UNSYNCHRONIZED, this.map);
            if (em1 != null) {
                this.logTrace("Received non-null EntityManager");
                pass1 = true;
            } else {
                this.logErr("Received null EntityManager");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        try {
            this.logMsg("Test SYNCHRONIZED");
            EntityManager em2 = this.getEntityManagerFactory().createEntityManager(SynchronizationType.SYNCHRONIZED, this.map);
            if (em2 != null) {
                this.logTrace("Received non-null EntityManager");
                pass2 = true;
            } else {
                this.logErr("Received null EntityManager");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("createEntityManagerSynchronizationTypeMapTest failed");
        }
    }

    public void createEntityManagerSynchronizationTypeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Test UNSYNCHRONIZED");
            EntityManager em1 = this.getEntityManagerFactory().createEntityManager(SynchronizationType.UNSYNCHRONIZED);
            if (em1 != null) {
                this.logTrace("Received non-null EntityManager");
                pass1 = true;
            } else {
                this.logErr("Received null EntityManager");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        try {
            this.logMsg("Test SYNCHRONIZED");
            EntityManager em2 = this.getEntityManagerFactory().createEntityManager(SynchronizationType.SYNCHRONIZED);
            if (em2 != null) {
                this.logTrace("Received non-null EntityManager");
                pass2 = true;
            } else {
                this.logErr("Received null EntityManager");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("createEntityManagerSynchronizationTypeTest failed");
        }
    }

    public void joinTransactionTransactionRequiredExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityManager().joinTransaction();
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException e) {
            this.logTrace("TransactionRequiredException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("joinTransactionTransactionRequiredExceptionTest failed");
        }
    }
}

