/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)DomHandler.test.xml	1.6 07/06/05 Igor Tseytin
 * Generated from : api/jakarta_xml/bind/annotation/DomHandler/DomHandler.test.xml
 *
 * Provides DomHandler implementation tests
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.annotation.DomHandler;

import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.DomHandler;
import jakarta.xml.bind.annotation.W3CDomHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import org.w3c.dom.Document;


public class DomHandlerTests extends MultiTest {

    void assertT( boolean val, String msg ){
        if( !val )
            throw new RuntimeException(msg);
    }

    /* standalone interface */
    public static void main(String argv[]) {
        DomHandlerTests test = new DomHandlerTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Functional tests for DomHandler,
     * the test calls createUnmarshaller method.
     */
    public Status createUnmarshaller001() {
        DomHandler/*<Element,DOMResult>*/ instance = new W3CDomHandler();
        ValidationEventCollector eh = new ValidationEventCollector();
        Result result = instance.createUnmarshaller( eh );
        assertT( result != null || eh.hasEvents(), "createUnmarshaller() returns null but doesn't report error into EventHandler" );
        return Status.passed("Ok");
        }

    /**
     * Functional tests for DomHandler,
     * the test calls marshal method with wrong parameters.
     */
    public Status marshal001() {
        DomHandler/*<Element,DOMResult>*/ instance = new W3CDomHandler();
        ValidationEventCollector eh = new ValidationEventCollector();
        Source src = null;
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Object element = doc;
            src = instance.marshal( element, eh );
        } catch(Exception x) {}
        assertT( src == null, "DomHandler.marshal() returns non-null value for a wrong argument" );
        return Status.passed("Ok");
        }

    /**
     * Functional tests for DomHandler,
     * the test calls marshal method with valid parameters.
     */
    public Status marshal002() {
        DomHandler/*<Element,DOMResult>*/ instance = new W3CDomHandler();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            ValidationEventCollector eh = new ValidationEventCollector();
            Object element = doc.getDocumentElement();
            Source src = instance.marshal( element, eh );
            assertT( src != null, "DomHandler.marshal() returns null on valid parameters");
        } catch(ParserConfigurationException x){
            x.printStackTrace( ref );
            return Status.failed( x.toString() );
        }
        return Status.passed("Ok");
        }
}
