/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.clientrequestcontext;

import ee.jakarta.tck.ws.rs.api.client.clientrequestcontext.ContextProvider;
import ee.jakarta.tck.ws.rs.api.client.clientrequestcontext.GetPropertyNamesIsImmutableProvider;
import ee.jakarta.tck.ws.rs.api.client.clientrequestcontext.GetPropertyNamesProvider;
import ee.jakarta.tck.ws.rs.api.client.clientrequestcontext.GetSetPropertyProvider;
import ee.jakarta.tck.ws.rs.api.client.clientrequestcontext.RemovePropertyProvider;
import ee.jakarta.tck.ws.rs.api.client.clientrequestcontext.SetEntityProvider;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanRuntimeDelegate;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanWithAnnotation;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.ByteArrayInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 8883841555516513076L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void abortWithTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Response r = Response.status((Response.Status)Response.Status.CREATED).build();
                context.abortWith(r);
            }
        };
        Invocation i = JAXRSClientIT.buildInvocation(provider);
        Response r = JAXRSClientIT.invoke(i);
        JAXRSClientIT.assertStatus(r, Response.Status.CREATED);
    }

    @Test
    public void getAcceptableLanguagesTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                List locales = context.getAcceptableLanguages();
                String languages = JaxrsUtil.iterableToString(";", locales);
                Response r = Response.ok((Object)languages).build();
                context.abortWith(r);
            }
        };
        Invocation.Builder builder = JAXRSClientIT.buildBuilder(provider);
        Invocation invocation = builder.acceptLanguage(new Locale[]{Locale.CANADA_FRENCH}).acceptLanguage(new Locale[]{Locale.PRC}).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, Locale.CANADA_FRENCH.toString());
        JAXRSClientIT.assertContains(entity, Locale.PRC.toString());
    }

    @Test
    public void getAcceptableLanguagesByWeightsTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                List locales = context.getAcceptableLanguages();
                String languages = JaxrsUtil.iterableToString(";", locales);
                Response r = Response.ok((Object)languages).build();
                context.abortWith(r);
            }
        };
        Invocation.Builder builder = JAXRSClientIT.buildBuilder(provider);
        Invocation invocation = builder.acceptLanguage(new String[]{"da, en-gb;q=0.6, en-us;q=0.7"}).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = ((String)response.readEntity(String.class)).toLowerCase();
        JAXRSClientIT.assertContains(entity, "da");
        JAXRSClientIT.assertContains(entity, "gb");
        JAXRSClientIT.assertContains(entity, "us");
        int indexDa = entity.indexOf("da");
        int indexUs = entity.indexOf("us");
        int indexGb = entity.indexOf("gb");
        Assertions.assertTrue((indexDa < indexUs && indexUs < indexGb ? 1 : 0) != 0, (String)("List of acceptable languages " + entity + " is not sorted by q values"));
    }

    @Test
    public void getAcceptableLanguagesIsImmutableTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                List locales = context.getAcceptableLanguages();
                try {
                    locales.add(Locale.JAPAN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                locales = context.getAcceptableLanguages();
                boolean b = locales.contains(Locale.JAPAN);
                Assertions.assertTrue((!b ? 1 : 0) != 0, (String)"getAcceptableLanguages is not read-only");
                Response r = Response.ok().build();
                context.abortWith(r);
            }
        };
        WebTarget target = JAXRSClientIT.buildTarget(provider);
        Invocation.Builder builder = target.request();
        Invocation invocation = builder.header("Accept-Language", (Object)"da, en-gb;q=0.6, en-us;q=0.7").buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        JAXRSClientIT.assertStatus(response, Response.Status.OK);
    }

    @Test
    public void getAcceptableMediaTypesTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                List types = context.getAcceptableMediaTypes();
                String medias = JaxrsUtil.iterableToString(";", types);
                Response r = Response.ok((Object)medias).build();
                context.abortWith(r);
            }
        };
        String media = "text/*;q=0.3, text/html;q=0.7, text/html;level=1, text/html;level=2;q=0.4, */*;q=0.5";
        Invocation.Builder builder = JAXRSClientIT.buildBuilder(provider);
        Invocation invocation = builder.header("Accept", (Object)media).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "text/*");
        JAXRSClientIT.assertContains(entity, "text/html");
        JAXRSClientIT.assertContains(entity, "*/*");
    }

    @Test
    public void getAcceptableMediaTypesIsSortedTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                List types = context.getAcceptableMediaTypes();
                String medias = JaxrsUtil.iterableToString(";", types);
                Response r = Response.ok((Object)medias).build();
                context.abortWith(r);
            }
        };
        String media = "text/plain;q=0.3, text/html;q=0.7, text/xml;level=1, text/java;level=2;q=0.4, */*;q=0.5";
        Invocation.Builder builder = JAXRSClientIT.buildBuilder(provider);
        Invocation invocation = builder.header("Accept", (Object)media).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = ((String)response.readEntity(String.class)).toLowerCase();
        int indexXml = entity.indexOf("text/xml");
        int indexHtml = entity.indexOf("text/html");
        int indexAny = entity.indexOf("*/*");
        int indexJava = entity.indexOf("text/java");
        int indexPlain = entity.indexOf("text/plain");
        Assertions.assertTrue((indexXml < indexHtml && indexHtml < indexAny && indexAny < indexJava && indexJava < indexPlain ? 1 : 0) != 0, (String)("Media Types " + entity + " are not sorted"));
    }

    @Test
    public void getAcceptableMediaTypesIsImmutableTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                List types = context.getAcceptableMediaTypes();
                try {
                    types.add(MediaType.APPLICATION_JSON_TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                types = context.getAcceptableMediaTypes();
                boolean b = types.contains(MediaType.APPLICATION_JSON_TYPE);
                Assertions.assertTrue((!b ? 1 : 0) != 0, (String)"getAcceptableMediaTypes is not read only");
                Response r = Response.ok().build();
                context.abortWith(r);
            }
        };
        String media = "text/*;q=0.3, text/html;q=0.7, text/html;level=1, text/html;level=2;q=0.4, */*;q=0.5";
        Invocation.Builder builder = JAXRSClientIT.buildBuilder(provider);
        Invocation invocation = builder.header("Accept", (Object)media).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        JAXRSClientIT.assertStatus(response, Response.Status.OK);
    }

    @Test
    public void getClientTest() throws JAXRSCommonClient.Fault {
        final Client client = ClientBuilder.newClient();
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Client contextClient = context.getClient();
                Assertions.assertTrue((client == contextClient ? 1 : 0) != 0, (String)"the client instance is different from the context one");
                Response r = Response.ok().build();
                context.abortWith(r);
            }
        };
        client.register((Object)provider);
        WebTarget target = client.target(JAXRSClientIT.getUrl());
        Invocation invocation = target.request().buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        JAXRSClientIT.assertStatus(response, Response.Status.OK);
    }

    @Test
    public void getConfigurationTest() throws JAXRSCommonClient.Fault {
        final Client client = ClientBuilder.newClient();
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Client contextClient = context.getClient();
                JAXRSCommonClient.assertEquals(contextClient, client, "the client instance is different from the context one");
                Configuration contextConfig = context.getConfiguration();
                JAXRSCommonClient.assertNotNull(contextConfig, "context.getConfiguration() returned null");
                Response r = Response.ok().build();
                context.abortWith(r);
            }
        };
        client.register((Object)provider);
        WebTarget target = client.target(JAXRSClientIT.getUrl());
        Invocation invocation = target.request().buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        JAXRSClientIT.assertStatus(response, Response.Status.OK);
    }

    @Test
    public void getCookiesTest() throws JAXRSCommonClient.Fault {
        Cookie cts = new Cookie("cts", "cts");
        Cookie tck = new Cookie("tck", "tck");
        Cookie jee = new Cookie("jee", "jee");
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                String cookies = JaxrsUtil.iterableToString(";", context.getCookies().values());
                Response r = Response.ok((Object)cookies).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).cookie(cts).cookie(tck).cookie(jee).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "cts");
        JAXRSClientIT.assertContains(entity, "tck");
        JAXRSClientIT.assertContains(entity, "jee");
    }

    @Test
    public void getCookiesIsImmutableTest() throws JAXRSCommonClient.Fault {
        final Cookie cts = new Cookie("cts", "cts");
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Map cookies = context.getCookies();
                try {
                    cookies.put("test", cts);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cookies = context.getCookies();
                Cookie cookie = (Cookie)cookies.get("test");
                Assertions.assertTrue((cookie == null ? 1 : 0) != 0, (String)"getCookies is not read-only");
                Response r = Response.ok().build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).cookie(cts).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        JAXRSClientIT.assertStatus(response, Response.Status.OK);
    }

    @Test
    public void getDateNullTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Date date = context.getDate();
                Response r = Response.ok((Object)(date == null ? "NULL" : date.toString())).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildInvocation(provider);
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "NULL");
    }

    @Test
    public void getDateTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Date date = context.getDate();
                Response r = Response.ok((Object)date.toString()).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).header("Date", (Object)"Tue, 15 Nov 1994 08:12:31 GMT").buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "Nov");
        JAXRSClientIT.assertContains(entity, "1994");
        JAXRSClientIT.assertContains(entity, "31");
    }

    @Test
    public void getEntityNullTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Object entity = context.getEntity();
                Response r = Response.ok((Object)(entity == null ? "NULL" : entity.toString())).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildInvocation(provider);
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "NULL");
    }

    @Test
    public void getEntityTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Object entity = context.getEntity();
                Response r = Response.ok((Object)entity.toString()).build();
                context.abortWith(r);
            }
        };
        Entity<String> post = this.createEntity("test");
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildPost(post);
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "test");
    }

    @Test
    public void getEntityAnnotationsTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = ContextProvider.class.getAnnotations();
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Annotation[] annotations = context.getEntityAnnotations();
                String first = annotations == null ? "NULL" : (annotations.length == 0 ? "0" : annotations[0].annotationType().getName());
                Response r = Response.ok((Object)first).build();
                context.abortWith(r);
            }
        };
        Entity post = Entity.entity((Object)"test", (MediaType)MediaType.WILDCARD_TYPE, (Annotation[])annotations);
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildPost(post);
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, annotations[0].annotationType().getName());
    }

    @Test
    public void getEntityAnnotationsIsNotTakenFromEntityClassTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Annotation[] annotations = context.getEntityAnnotations();
                String first = annotations == null ? "0" : String.valueOf(annotations.length);
                Response r = Response.ok((Object)first).build();
                context.abortWith(r);
            }
        };
        Entity<StringBeanWithAnnotation> post = this.createEntity(new StringBeanWithAnnotation("test"));
        Invocation invocation = ((WebTarget)JAXRSClientIT.buildTarget(provider).register(StringBeanEntityProvider.class)).request().buildPost(post);
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "0");
    }

    @Test
    public void getEntityAnnotationsNullTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Annotation[] annotations = context.getEntityAnnotations();
                String len = annotations == null ? "0" : String.valueOf(annotations.length);
                Response r = Response.ok((Object)len).build();
                context.abortWith(r);
            }
        };
        Entity<String> post = this.createEntity("test");
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildPost(post);
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "0");
    }

    @Test
    public void getEntityClassTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Class clazz = context.getEntityClass();
                Response r = Response.ok((Object)clazz.getName()).build();
                context.abortWith(r);
            }
        };
        Entity<ByteArrayInputStream> post = this.createEntity(new ByteArrayInputStream("test".getBytes()));
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildPost(post);
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, ByteArrayInputStream.class.getName());
    }

    @Test
    public void getEntityClassListStringTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Class clazz = context.getEntityClass();
                Response r = Response.ok((Object)clazz.getName()).build();
                context.abortWith(r);
            }
        };
        ArrayList list = new ArrayList();
        Entity post = this.createEntity(list);
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildPost(post);
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, ArrayList.class.getName());
    }

    @Test
    public void getEntityTypeListStringTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Type type = context.getEntityType();
                String entity = type.toString();
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        ArrayList list = new ArrayList();
        GenericEntity<List<String>> generic = new GenericEntity<List<String>>(list){};
        Entity<22> post = this.createEntity(generic);
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildPost(post);
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, String.class.getName());
    }

    @Test
    public void getHeadersTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                MultivaluedMap headers = context.getHeaders();
                String entity = JaxrsUtil.iterableToString(";", headers.keySet());
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).header("Accept", (Object)"text/html").header("tck", (Object)"cts").header("Date", (Object)"Tue, 15 Nov 1994 08:12:31 GMT").buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "Accept");
        JAXRSClientIT.assertContains(entity, "Date");
        JAXRSClientIT.assertContains(entity, "tck");
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                MultivaluedMap headers = context.getHeaders();
                headers.add((Object)"Accept", (Object)"application/json");
                headers = context.getHeaders();
                String entity = JaxrsUtil.iterableToString(";", headers.keySet());
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String entity = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, "Accept");
    }

    @Test
    public void getHeaderStringTest() throws JAXRSCommonClient.Fault {
        String TCK = "cts";
        String DATE = "Tue, 15 Nov 1994 08:12:31 GMT";
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                String value = context.getHeaderString("tck");
                JAXRSCommonClient.assertContainsIgnoreCase(value, "cts", new Object[]{"The expected value", "cts", "was not found, found", value, "instead"});
                value = context.getHeaderString("accept");
                JAXRSCommonClient.assertContainsIgnoreCase(value, "text/html", new Object[]{"The expected value", "text/html", "was not found, found", value, "instead"});
                value = context.getHeaderString("date");
                JAXRSCommonClient.assertContainsIgnoreCase(value, "Tue, 15 Nov 1994 08:12:31 GMT", new Object[]{"The expected value", "Tue, 15 Nov 1994 08:12:31 GMT", "was not found, found", value, "instead"});
                Response r = Response.ok().build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).header("Accept", (Object)"text/html").header("tck", (Object)new StringBuffer().append("cts")).header("Date", (Object)"Tue, 15 Nov 1994 08:12:31 GMT").buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        JAXRSClientIT.assertStatus(response, Response.Status.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getHeaderStringUsingHeaderDelegateTest() throws JAXRSCommonClient.Fault {
        String name = "BEAN";
        StringBean bean = new StringBean("BEAN");
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                String value = context.getHeaderString("BEAN");
                Response r = Response.ok((Object)value).build();
                context.abortWith(r);
            }
        };
        RuntimeDelegate original = RuntimeDelegate.getInstance();
        RuntimeDelegate.setInstance((RuntimeDelegate)new StringBeanRuntimeDelegate(original));
        try {
            Invocation invocation = JAXRSClientIT.buildBuilder(provider).header("BEAN", (Object)bean).buildGet();
            Response response = JAXRSClientIT.invoke(invocation);
            String body = (String)response.readEntity(String.class);
            JAXRSClientIT.assertContains("BEAN".toLowerCase(), body.toLowerCase());
        }
        finally {
            RuntimeDelegate.setInstance((RuntimeDelegate)original);
            StringBeanRuntimeDelegate.assertNotStringBeanRuntimeDelegate();
        }
    }

    @Test
    public void getLanguageIsNullTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Locale lang = context.getLanguage();
                String entity = lang == null ? "NULL" : lang.toString();
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        Entity<String> entity = this.createEntity("TEST");
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildPost(entity);
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "NULL");
    }

    @Test
    public void getLanguageTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Locale lang = context.getLanguage();
                String entity = lang == null ? "NULL" : lang.toString();
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        Locale locale = Locale.TRADITIONAL_CHINESE;
        Variant variant = new Variant(MediaType.TEXT_XML_TYPE, locale, null);
        Entity entity = Entity.entity((Object)"TEST", (Variant)variant);
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildPost(entity);
        Response response = JAXRSClientIT.invoke(invocation);
        String body = ((String)response.readEntity(String.class)).toLowerCase().replace('-', '_');
        JAXRSClientIT.assertContains(body, locale.toString().toLowerCase());
    }

    @Test
    public void getMediaTypeIsNullTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                MediaType media = context.getMediaType();
                String entity = media == null ? "NULL" : media.toString();
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "NULL");
    }

    @Test
    public void getMediaTypeTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                MediaType media = context.getMediaType();
                String entity = media == null ? "NULL" : media.toString();
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        Entity entity = Entity.entity((Object)"TEST", (String)"application/x-www-form-urlencoded");
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildPost(entity);
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "application/x-www-form-urlencoded");
    }

    @Test
    public void getMethodTest() throws JAXRSCommonClient.Fault {
        String body;
        Response response;
        Invocation invocation;
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                String method = context.getMethod();
                Response r = Response.ok((Object)method).build();
                context.abortWith(r);
            }
        };
        Entity<String> entity = this.createEntity("TEST");
        for (String method : new String[]{"OPTIONS", "DELETE", "GET", "TRACE"}) {
            invocation = JAXRSClientIT.buildBuilder(provider).build(method);
            response = JAXRSClientIT.invoke(invocation);
            body = ((String)response.readEntity(String.class)).toUpperCase();
            JAXRSClientIT.assertContains(body, method);
        }
        for (String method : new String[]{"PUT", "POST"}) {
            invocation = JAXRSClientIT.buildBuilder(provider).build(method, entity);
            response = JAXRSClientIT.invoke(invocation);
            body = ((String)response.readEntity(String.class)).toUpperCase();
            JAXRSClientIT.assertContains(body, method);
        }
    }

    @Test
    public void getPropertyIsNullTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                Object property = context.getProperty("PROPERTY");
                String entity = property == null ? "NULL" : property.toString();
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "NULL");
    }

    @Test
    public void getSetPropertyTest() throws JAXRSCommonClient.Fault {
        AtomicInteger counter = new AtomicInteger(0);
        GetSetPropertyProvider provider = new GetSetPropertyProvider(counter);
        GetSetPropertyProvider provider2 = new GetSetPropertyProvider(counter){};
        Invocation invocation = JAXRSClientIT.buildInvocation(provider, provider2);
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "value");
    }

    @Test
    public void getPropertyNamesTest() throws JAXRSCommonClient.Fault {
        AtomicInteger counter = new AtomicInteger(0);
        GetPropertyNamesProvider provider = new GetPropertyNamesProvider(counter);
        GetPropertyNamesProvider provider2 = new GetPropertyNamesProvider(counter){};
        Invocation invocation = JAXRSClientIT.buildInvocation(provider, provider2);
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "PROPERTY1");
        JAXRSClientIT.assertContains(body, "PROPERTY2");
    }

    @Test
    public void getPropertyNamesIsImmutableTest() throws JAXRSCommonClient.Fault {
        AtomicInteger counter = new AtomicInteger(0);
        GetPropertyNamesIsImmutableProvider provider = new GetPropertyNamesIsImmutableProvider(counter);
        Invocation invocation = JAXRSClientIT.buildInvocation(provider);
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertEqualsInt(0, counter.get(), "getPropertyNames collection is not immutable");
        JAXRSClientIT.assertEquals("0", body, "getPropertyNames collection is not immutable");
        JAXRSClientIT.logMsg("getPropertyNames is immutable as expected");
    }

    @Test
    public void getStringHeadersTest() throws JAXRSCommonClient.Fault {
        String TCK = "cts";
        String DATE = "Tue, 15 Nov 1994 08:12:31 GMT";
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                MultivaluedMap map = context.getStringHeaders();
                StringBuilder value = new StringBuilder();
                value.append((String)map.getFirst((Object)"Accept")).append(" ");
                value.append((String)map.getFirst((Object)"tck")).append(" ");
                value.append((String)map.getFirst((Object)"Date"));
                Response r = Response.ok((Object)value.toString()).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).header("Accept", (Object)"text/html").header("tck", (Object)"cts").header("Date", (Object)"Tue, 15 Nov 1994 08:12:31 GMT").buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "text/html");
        JAXRSClientIT.assertContains(body, "cts");
        JAXRSClientIT.assertContains(body, "Tue, 15 Nov 1994 08:12:31 GMT");
    }

    @Test
    public void getStringHeadersReflectsTheUnderlayingMapTest() throws JAXRSCommonClient.Fault {
        String TCK = "cts";
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                context.getHeaders().add((Object)"cts", (Object)"cts");
                MultivaluedMap map = context.getStringHeaders();
                String value = (String)map.getFirst((Object)"cts");
                Response r = Response.ok((Object)value).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildBuilder(provider).buildGet();
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "cts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getStringHeadersUsingHeaderDelegateTest() throws JAXRSCommonClient.Fault {
        String TCK = "cts";
        StringBean bean = new StringBean("cts");
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                MultivaluedMap map = context.getStringHeaders();
                StringBuilder value = new StringBuilder();
                value.append((String)map.getFirst((Object)"cts"));
                Response r = Response.ok((Object)value.toString()).build();
                context.abortWith(r);
            }
        };
        RuntimeDelegate delegate = RuntimeDelegate.getInstance();
        RuntimeDelegate.setInstance((RuntimeDelegate)new StringBeanRuntimeDelegate(delegate));
        try {
            Invocation invocation = JAXRSClientIT.buildBuilder(provider).header("cts", (Object)bean).buildGet();
            Response response = JAXRSClientIT.invoke(invocation);
            String body = (String)response.readEntity(String.class);
            JAXRSClientIT.assertContains(body, "cts");
        }
        finally {
            RuntimeDelegate.setInstance((RuntimeDelegate)delegate);
            StringBeanRuntimeDelegate.assertNotStringBeanRuntimeDelegate();
        }
    }

    @Test
    public void getUriTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                URI uri = context.getUri();
                String entity = uri.toASCIIString();
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildInvocation(provider);
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, JAXRSClientIT.getUrl());
    }

    @Test
    public void hasEntityTest() throws JAXRSCommonClient.Fault {
        ContextProvider provider = new ContextProvider(){

            @Override
            protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
                boolean has = context.hasEntity();
                String entity = String.valueOf(has);
                Response r = Response.ok((Object)entity).build();
                context.abortWith(r);
            }
        };
        Invocation invocation = JAXRSClientIT.buildInvocation(provider);
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "false");
        Entity<String> entity = this.createEntity("TEST");
        WebTarget target = JAXRSClientIT.buildTarget(provider);
        invocation = target.request().buildPost(entity);
        response = JAXRSClientIT.invoke(invocation);
        body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "true");
    }

    @Test
    public void removePropertyTest() throws JAXRSCommonClient.Fault {
        AtomicInteger counter = new AtomicInteger(0);
        RemovePropertyProvider provider = new RemovePropertyProvider(counter);
        RemovePropertyProvider provider2 = new RemovePropertyProvider(counter){};
        RemovePropertyProvider provider3 = new RemovePropertyProvider(counter){};
        Invocation invocation = JAXRSClientIT.buildInvocation(provider, provider2, provider3);
        Response response = JAXRSClientIT.invoke(invocation);
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, "NULL");
    }

    @Test
    public void setEntityTest() throws JAXRSCommonClient.Fault {
        AtomicInteger counter = new AtomicInteger(0);
        SetEntityProvider provider = new SetEntityProvider(counter);
        SetEntityProvider provider2 = new SetEntityProvider(counter){};
        Entity<ByteArrayInputStream> entity = this.createEntity(new ByteArrayInputStream("test".getBytes()));
        WebTarget target = JAXRSClientIT.buildTarget(provider, provider2);
        Invocation invocation = target.request().buildPost(entity);
        Response response = JAXRSClientIT.invoke(invocation);
        JAXRSClientIT.assertStatus(response, Response.Status.OK);
    }

    protected static Response invoke(Invocation i) throws JAXRSCommonClient.Fault {
        Response r = null;
        try {
            r = i.invoke();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof JAXRSCommonClient.Fault) {
                throw (JAXRSCommonClient.Fault)cause;
            }
            throw new JAXRSCommonClient.Fault(e);
        }
        return r;
    }

    protected static Invocation buildInvocation(ContextProvider ... provider) {
        WebTarget target = JAXRSClientIT.buildTarget(provider);
        Invocation i = target.request().buildGet();
        return i;
    }

    protected static WebTarget buildTarget(ContextProvider ... providers) {
        Client client = ClientBuilder.newClient();
        for (ContextProvider provider : providers) {
            client.register((Object)provider);
        }
        WebTarget target = client.target(JAXRSClientIT.getUrl());
        return target;
    }

    protected static Invocation.Builder buildBuilder(ContextProvider ... provider) {
        Invocation.Builder builder = JAXRSClientIT.buildTarget(provider).request();
        return builder;
    }

    protected static void assertStatus(Response r, Response.Status status) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((r.getStatus() == status.getStatusCode() ? 1 : 0) != 0, (String)("Expected " + status.getStatusCode() + " got " + r.getStatus()));
        TestUtil.logMsg("Found expected status: " + status.getStatusCode());
    }

    protected static void assertContains(String string, String substring) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)string.contains(substring), (String)(string + " does NOT contain " + substring + ", it is: " + string));
        TestUtil.logMsg("Found expected substring: " + substring);
    }

    protected static String getUrl() {
        return "http://localhost:8080/404URL/";
    }

    protected <T> Entity<T> createEntity(T entity) {
        return Entity.entity(entity, (MediaType)MediaType.WILDCARD_TYPE);
    }
}

