/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.client;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 7355465562476492891L;
    protected transient WebTarget target;
    protected transient Client client;

    public JAXRSClientIT() {
        this.setClientAndWebTarget();
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void closeOnClientConfigTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "getConfiguration", new Object[0]);
    }

    @Test
    public void closeOnClientInvocationWithLinkTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        Link link = Link.fromUri((String)"cts").build(new Object[0]);
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "invocation", link);
    }

    @Test
    public void closeOnClientTargetWithLinkTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        Link link = Link.fromUri((String)"cts").build(new Object[0]);
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "target", link);
    }

    @Test
    public void closeOnClientTargetWithStringTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "target", "cts");
    }

    @Test
    public void closeOnClientTargetWithUriTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        URI uri = URI.create("cts");
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "target", uri);
    }

    @Test
    public void closeOnClientRegisterClassTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "register", StringBeanEntityProvider.class);
    }

    @Test
    public void closeOnClientRegisterObjectTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "register", new StringBeanEntityProvider());
    }

    @Test
    public void closeOnClientRegisterClassWithContractsTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "register", StringBeanEntityProvider.class, new Class[]{MessageBodyWriter.class});
    }

    @Test
    public void closeOnClientRegisterClassWithPriorityTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "register", StringBeanEntityProvider.class, 100);
    }

    @Test
    public void closeOnClientRegisterClassMapTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        HashMap<Class<MessageBodyReader>, Integer> contracts = new HashMap<Class<MessageBodyReader>, Integer>();
        contracts.put(MessageBodyReader.class, 100);
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "register", StringBeanEntityProvider.class, contracts);
    }

    @Test
    public void closeOnClientRegisterObjectWithContractsTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "register", new StringBeanEntityProvider(), new Class[]{MessageBodyReader.class});
    }

    @Test
    public void closeOnClientRegisterObjectWithPriorityTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "register", new StringBeanEntityProvider(), 100);
    }

    @Test
    public void closeOnClientRegisterObjectWithMapTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        HashMap<Class<MessageBodyReader>, Integer> contracts = new HashMap<Class<MessageBodyReader>, Integer>();
        contracts.put(MessageBodyReader.class, 100);
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "register", new StringBeanEntityProvider(), contracts);
    }

    @Test
    public void closeOnClientPropertyTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        HashMap<Class<MessageBodyReader>, Integer> contracts = new HashMap<Class<MessageBodyReader>, Integer>();
        contracts.put(MessageBodyReader.class, 100);
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "property", "A", "B");
    }

    @Test
    public void closeOnClientTargetWithUriBuilderTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        Link link = Link.fromUri((String)"cts").build(new Object[0]);
        UriBuilder builder = UriBuilder.fromUri((URI)link.getUri());
        JAXRSClientIT.assertException(IllegalStateException.class, this.client, "target", builder);
    }

    @Test
    public void closeOnWebTargetConfigTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "getConfiguration", new Object[0]);
    }

    @Test
    public void closeOnWebTargetGetUriTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "getUri", new Object[0]);
    }

    @Test
    public void closeOnWebTargetGetUriBuilderTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "getUriBuilder", new Object[0]);
    }

    @Test
    public void closeOnWebTargetMatrixParamTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "matrixParam", "cts", new Object[]{"tck"});
    }

    @Test
    public void closeOnWebTargetPathTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "path", "cts");
    }

    @Test
    public void closeOnWebTargetQueryParamTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "queryParam", "cts", new Object[]{"tck"});
    }

    @Test
    public void closeOnWebTargetRegisterClassTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "register", StringBeanEntityProvider.class);
    }

    @Test
    public void closeOnWebTargetRegisterObjectTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "register", new StringBeanEntityProvider());
    }

    @Test
    public void closeOnWebTargetRegisterClassWithContractsTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "register", StringBeanEntityProvider.class, new Class[]{MessageBodyWriter.class});
    }

    @Test
    public void closeOnWebTargetRegisterClassWithPriorityTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "register", StringBeanEntityProvider.class, 100);
    }

    @Test
    public void closeOnWebTargetRegisterClassMapTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        HashMap<Class<MessageBodyReader>, Integer> contracts = new HashMap<Class<MessageBodyReader>, Integer>();
        contracts.put(MessageBodyReader.class, 100);
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "register", StringBeanEntityProvider.class, contracts);
    }

    @Test
    public void closeOnWebTargetRegisterObjectWithContractsTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "register", new StringBeanEntityProvider(), new Class[]{MessageBodyReader.class});
    }

    @Test
    public void closeOnWebTargetRegisterObjectWithPriorityTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "register", new StringBeanEntityProvider(), 100);
    }

    @Test
    public void closeOnWebTargetRegisterObjectWithMapTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        HashMap<Class<MessageBodyReader>, Integer> contracts = new HashMap<Class<MessageBodyReader>, Integer>();
        contracts.put(MessageBodyReader.class, 100);
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "register", new StringBeanEntityProvider(), contracts);
    }

    @Test
    public void closeOnWebTargetRequestTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "request", new Object[0]);
    }

    @Test
    public void closeOnWebTargetRequestWithMediaTypeTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "request", new Object[]{new MediaType[]{MediaType.APPLICATION_XML_TYPE}});
    }

    @Test
    public void closeOnWebTargetRequestWithMediaTypeNameTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "request", new Object[]{new String[]{"application/xml"}});
    }

    @Test
    public void closeOnWebTargetResolveTemplateStringObjectTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "resolveTemplate", "name", "value");
    }

    @Test
    public void closeOnWebTargetResolveTemplateStringObjectBooleanTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "resolveTemplate", "name", "value", true);
    }

    @Test
    public void closeOnWebTargetResolveTemplateFromEncodedTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "resolveTemplateFromEncoded", "name", "value");
    }

    @Test
    public void closeOnWebTargetResolveTemplatesMapTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        HashMap map = new HashMap();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "resolveTemplates", map);
    }

    @Test
    public void closeOnWebTargetResolveTemplatesMapBooleanTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        HashMap map = new HashMap();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "resolveTemplates", map, true);
    }

    @Test
    public void closeOnWebTargetPropertyTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        HashMap<Class<MessageBodyReader>, Integer> contracts = new HashMap<Class<MessageBodyReader>, Integer>();
        contracts.put(MessageBodyReader.class, 100);
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "property", "A", "B");
    }

    @Test
    public void closeOnWebTargetResolveTemplatesFromEncodedTest() throws JAXRSCommonClient.Fault {
        this.client.close();
        HashMap map = new HashMap();
        JAXRSClientIT.assertException(IllegalStateException.class, this.target, "resolveTemplatesFromEncoded", map);
    }

    @Test
    public void invocationFromLinkExceptionNoLinkTest() throws JAXRSCommonClient.Fault {
        String exceptionMessage = "NullPointerException successfully thrown when no link";
        String noExceptionMessage = "NullPointerException not thrown when no link";
        JAXRSClientIT.checkInvocationException(null, NullPointerException.class, exceptionMessage, noExceptionMessage);
    }

    @Test
    public void targetStringTest() throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((this.target != null ? 1 : 0) != 0, (String)"WebTarget is null");
    }

    @Test
    public void targetWithStringIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        String sWebTarget = ":cts:8080//tck:90090//jaxrs ";
        try {
            new URI(sWebTarget);
            throw new JAXRSCommonClient.Fault("URI(" + sWebTarget + ") is valid");
        }
        catch (URISyntaxException e1) {
            JAXRSClientIT.logMsg("Uri is not a valid URI as expected:", e1);
            try {
                this.target = this.client.target(sWebTarget);
                throw new JAXRSCommonClient.Fault("IllegalArgumentException was not thrown for target " + sWebTarget);
            }
            catch (IllegalArgumentException e) {
                TestUtil.logMsg("IllegalArgumentException was successfully thrown for target " + sWebTarget + " as expected");
                return;
            }
        }
    }

    @Test
    public void targetWithStringNullPointerExceptionTest() throws JAXRSCommonClient.Fault {
        String sWebTarget = null;
        try {
            this.target = this.client.target(sWebTarget);
            throw new JAXRSCommonClient.Fault("NullPointerException was not thrown for null target");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg("NullPointerException was successfully thrown for null target as expected");
            return;
        }
    }

    @Test
    public void targetUriTest() throws JAXRSCommonClient.Fault {
        URI uri = URI.create(this.getUrl("call"));
        this.target = this.client.target(uri);
        Assertions.assertTrue((this.target != null ? 1 : 0) != 0, (String)"WebTarget is null");
    }

    @Test
    public void targetWithUriNullPointerExceptionTest() throws JAXRSCommonClient.Fault {
        URI uri = null;
        try {
            this.target = this.client.target(uri);
            throw new JAXRSCommonClient.Fault("NullPointerException was not thrown for null target");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg("NullPointerException was successfully thrown for null target as expected");
            return;
        }
    }

    @Test
    public void targetUriBuilderTest() throws JAXRSCommonClient.Fault {
        UriBuilder builder = UriBuilder.fromUri((String)this.getUrl("call"));
        this.target = this.client.target(builder);
        Assertions.assertTrue((this.target != null ? 1 : 0) != 0, (String)"WebTarget is null");
    }

    @Test
    public void targetWithUriBuilderNullPointerExceptionTest() throws JAXRSCommonClient.Fault {
        UriBuilder builder = null;
        try {
            this.target = this.client.target(builder);
            throw new JAXRSCommonClient.Fault("NullPointerException was not thrown for null target");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg("NullPointerException was successfully thrown for null target as expected");
            return;
        }
    }

    @Test
    public void targetLinkTest() throws JAXRSCommonClient.Fault {
        URI uri = UriBuilder.fromPath((String)this.getUrl("call")).build(new Object[0]);
        Link link = Link.fromUri((URI)uri).build(new Object[0]);
        this.target = this.client.target(link);
        Assertions.assertTrue((this.target != null ? 1 : 0) != 0, (String)"WebTarget is null");
    }

    @Test
    public void targetWithLinkNullPointerExceptionTest() throws JAXRSCommonClient.Fault {
        Link link = null;
        try {
            this.target = this.client.target(link);
            throw new JAXRSCommonClient.Fault("NullPointerException was not thrown for null target");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg("NullPointerException was successfully thrown for null target as expected");
            return;
        }
    }

    protected static <T extends Exception> void checkInvocationException(Link link, Class<T> exception, String messageOnException, String messageNoException) throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        try {
            client.invocation(link);
            throw new JAXRSCommonClient.Fault(messageNoException);
        }
        catch (Exception e) {
            if (!exception.isInstance(e)) {
                throw new JAXRSCommonClient.Fault(e);
            }
            TestUtil.logMsg(messageOnException);
            return;
        }
    }

    protected void setClientAndWebTarget() {
        this.client = ClientBuilder.newClient();
        this.target = this.client.target("cts");
    }

    protected static void assertException(Class<? extends Exception> exception, Object object, String method, Object ... args) throws JAXRSCommonClient.Fault {
        Method m = JAXRSClientIT.getMethodByName(object.getClass(), method, args);
        Assertions.assertTrue((m != null ? 1 : 0) != 0, (String)("No method " + method + " for object " + object.getClass().getName() + " found"));
        System.out.println(m);
        try {
            m.invoke(object, args);
            Assertions.assertTrue((boolean)false, (String)("Method " + method + " did not throw " + exception.getSimpleName()));
        }
        catch (Exception e) {
            if (e.getCause() == null || !exception.isAssignableFrom(e.getCause().getClass())) {
                throw new JAXRSCommonClient.Fault(e);
            }
            JAXRSClientIT.logMsg(exception.getName(), "has been successfully thrown", e.getCause());
        }
    }

    protected static Method getMethodByName(Class<?> clazz, String name, Object ... args) {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            if (!m.getName().equals(name) || !JAXRSClientIT.fitsMethodArguments(m, args)) continue;
            return m;
        }
        return null;
    }

    protected static boolean fitsMethodArguments(Method method, Object ... args) {
        if (method.getParameterTypes().length != args.length) {
            return false;
        }
        Class<?>[] argClass = method.getParameterTypes();
        for (int i = 0; i != argClass.length; ++i) {
            if (args[i].getClass() == Class.class && argClass[i].getClass() != Class.class) {
                return false;
            }
            if (!argClass[i].isPrimitive() && !argClass[i].isAssignableFrom(args[i].getClass())) {
                return false;
            }
            if (!argClass[i].isPrimitive() || args[i] instanceof Number || args[i] instanceof Boolean) continue;
            return false;
        }
        return true;
    }

    protected String getUrl(String method) {
        StringBuilder url = new StringBuilder();
        url.append("http://").append(this._hostname).append(":").append(this._port);
        url.append("/").append(method);
        return url.toString();
    }
}

