/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.FormattingUtils;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.TextWriter;
import java.io.File;
import java.io.IOException;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

class Trace
implements Harness.Observer {
    private static final Format TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final String TEST_EXEC_TIME_STATS_LIMIT = "javatest.trace.execTimeStatsLimit";
    public static final int DEFAULT_STATS_LIMIT = 20;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Trace.class);
    private TextWriter out;
    private File reportDir;
    private BackupPolicy backupPolicy;
    private boolean useTimestamp;
    private Map<String, Long> testStartedMillis = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> runTimesMillis = new ConcurrentHashMap<String, Long>();

    Trace(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    @Override
    public synchronized void startingTestRun(Parameters params) {
        this.openOutput(params);
        if (this.out != null) {
            TestSuite ts = params.getTestSuite();
            String tsName = ts == null ? "null" : ts.getClass().getName();
            TestFinder tf = params.getWorkDirectory().getTestResultTable().getTestFinder();
            String tfName = tf == null ? "null" : tf.getClass().getName();
            this.println(i18n, "trace.starting", tsName, tfName);
        }
    }

    @Override
    public synchronized void startingTest(TestResult tr) {
        if (this.out != null) {
            TestDescription td = null;
            try {
                td = tr.getDescription();
            }
            catch (TestResult.Fault e) {
                e.printStackTrace();
            }
            if (td != null) {
                this.println(i18n, "trace.testStarting", (Object)td.getRootRelativeURL());
                this.testStartedMillis.put(td.getRootRelativeURL(), System.currentTimeMillis());
            }
        }
    }

    @Override
    public synchronized void finishedTest(TestResult tr) {
        if (this.out != null) {
            try {
                TestDescription td = tr.getDescription();
                Long started = this.testStartedMillis.get(td.getRootRelativeURL());
                String duration = "";
                if (started != null) {
                    long timeMillis = System.currentTimeMillis() - started;
                    this.runTimesMillis.put(td.getRootRelativeURL(), timeMillis);
                    this.testStartedMillis.remove(td.getRootRelativeURL());
                    duration = "(" + FormattingUtils.formattedDuration(Math.round((double)timeMillis * 0.001)) + ") ";
                }
                this.println(i18n, "trace.testFinished", duration + td.getRootRelativeURL(), tr.getStatus());
            }
            catch (TestResult.Fault e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void stoppingTestRun() {
        if (this.out != null) {
            this.println(i18n, "trace.stopping");
        }
    }

    @Override
    public synchronized void finishedTesting() {
        if (this.out != null) {
            List<Map.Entry> slowestTests;
            int statsLimit = 20;
            String statsLimitString = System.getProperty(TEST_EXEC_TIME_STATS_LIMIT);
            if (statsLimitString != null) {
                try {
                    statsLimit = Integer.valueOf(statsLimitString);
                    if (statsLimit <= 0) {
                        this.println("The parsed value of 'javatest.trace.execTimeStatsLimit' system property is not a positive integer. The value is '" + statsLimitString + "'");
                        this.println("Will skip stats printing.");
                    }
                }
                catch (NumberFormatException e3) {
                    this.println("Cannot parse the value of 'javatest.trace.execTimeStatsLimit' system property as an integer. The value is '" + statsLimitString + "'");
                    this.println("Using the default limit: 20");
                    statsLimit = 20;
                }
            }
            if (statsLimit > 0 && (slowestTests = this.runTimesMillis.entrySet().stream().sorted((e1, e2) -> ((Long)e2.getValue()).compareTo((Long)e1.getValue())).limit(statsLimit).collect(Collectors.toList())).size() > 0) {
                this.println("Below are the " + slowestTests.size() + " slowest tests: ");
                slowestTests.forEach(e -> this.println(FormattingUtils.formattedDuration(Math.round((double)((Long)e.getValue()).longValue() * 0.001)) + ": " + (String)e.getKey()));
            }
            this.println(i18n, "trace.cleanup");
        }
    }

    @Override
    public synchronized void finishedTestRun(boolean allOK) {
        if (this.out != null) {
            if (allOK) {
                this.println(i18n, "trace.doneOK");
            } else {
                this.println(i18n, "trace.doneNotOK");
            }
            this.close();
        }
    }

    @Override
    public synchronized void error(String s) {
        if (this.out != null) {
            this.println(i18n, "trace.error", (Object)s);
        }
    }

    private void openOutput(Parameters params) {
        try {
            WorkDirectory wd = params.getWorkDirectory();
            File traceFile = wd.getSystemFile("harness.trace");
            boolean autoFlush = Boolean.getBoolean("javatest.trace.autoflush");
            String timeStampSysProp = System.getProperty("javatest.trace.timestamp");
            this.useTimestamp = timeStampSysProp == null ? true : Boolean.parseBoolean(timeStampSysProp);
            this.out = new TextWriter(this.backupPolicy.backupAndOpenWriter(traceFile), autoFlush);
            this.out.println("# Trace file started at " + this.timeStamp());
            this.out.println("# " + ProductInfo.getName() + " version " + ProductInfo.getVersion());
            this.out.println("# class directory: " + Harness.getClassDir());
            this.out.println("# using java: " + System.getProperty("java.home"));
        }
        catch (IOException e) {
            System.err.println("Cannot open trace file: trace cancelled");
            System.err.println(e);
            this.out = null;
        }
    }

    private void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                System.err.println("Exception occurred writing to trace file");
                System.err.println(e);
            }
            this.out = null;
        }
    }

    private void println(I18NResourceBundle i18n, String key) {
        this.printLocalizedLn(i18n.getString(key));
    }

    private void println(I18NResourceBundle i18n, String key, Object arg) {
        this.printLocalizedLn(i18n.getString(key, arg));
    }

    private void println(I18NResourceBundle i18n, String key, Object ... args) {
        this.printLocalizedLn(i18n.getString(key, args));
    }

    private void printLocalizedLn(String msg) {
        this.println(this.useTimestamp ? this.timeStamp() + " " + msg : msg);
    }

    private void println(String msg) {
        try {
            this.out.println(msg);
            this.out.flush();
        }
        catch (IOException e) {
            System.err.println("Exception occurred writing to trace file");
            System.err.println(e);
            System.err.println("while trying to write: " + msg);
        }
    }

    private String timeStamp() {
        return TIMESTAMP_FORMAT.format(new Date());
    }
}

