/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.visibility;

import ee.jakarta.tck.json.bind.customizedmapping.visibility.model.CustomFieldVisibilityStrategy;
import ee.jakarta.tck.json.bind.customizedmapping.visibility.model.CustomVisibilityAnnotatedContainer;
import ee.jakarta.tck.json.bind.customizedmapping.visibility.model.SimpleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.visibility.model.customized.PackageCustomizedContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class VisibilityCustomizationTest {
    private static final Pattern PATTERN = Pattern.compile("\\{\\s*\"floatInstance\"\\s*:\\s*0.0\\s*}");
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testCustomVisibilityConfig() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withPropertyVisibilityStrategy((PropertyVisibilityStrategy)new CustomFieldVisibilityStrategy()));
        String jsonString = jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to hide fields during marshalling by applying custom visibility strategy using configuration.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)PATTERN));
        SimpleContainer unmarshalledObject = (SimpleContainer)jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"floatInstance\" : 1.0, \"integerInstance\" : 1 }", SimpleContainer.class);
        String validationMessage = "Failed to ignore fields during unmarshalling by applying custom visibility strategy using configuration.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntegerInstance(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)validationMessage, (Object)Float.valueOf(unmarshalledObject.getFloatInstance()), (Matcher)Matchers.is((Object)Float.valueOf(1.0f)));
    }

    @Test
    public void testCustomVisibilityAnnotation() {
        String jsonString = this.jsonb.toJson((Object)new CustomVisibilityAnnotatedContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to hide fields during marshalling by applying custom visibility strategy using JsonbVisibility annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)PATTERN));
        CustomVisibilityAnnotatedContainer unmarshalledObject = (CustomVisibilityAnnotatedContainer)this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"floatInstance\" : 1.0, \"integerInstance\" : 1 }", CustomVisibilityAnnotatedContainer.class);
        String validationMessage = "Failed to ignore fields during unmarshalling by applying custom visibility strategy using JsonbVisibility annotation.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntegerInstance(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)validationMessage, (Object)Float.valueOf(unmarshalledObject.getFloatInstance()), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
    }

    @Test
    public void testCustomVisibilityPackage() {
        String jsonString = this.jsonb.toJson((Object)new PackageCustomizedContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to hide fields during marshalling by applying custom visibility strategy using JsonbVisibility annotation on package.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)PATTERN));
        PackageCustomizedContainer unmarshalledObject = (PackageCustomizedContainer)this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\", \"floatInstance\" : 1.0, \"integerInstance\" : 1 }", PackageCustomizedContainer.class);
        String validationMessage = "Failed to ignore fields during unmarshalling by applying custom visibility strategy using JsonbVisibility annotation on package.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntegerInstance(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)validationMessage, (Object)Float.valueOf(unmarshalledObject.getFloatInstance()), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
    }
}

