/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

public class Fifo {
    private static final int defaultInitialSlots = 16;
    private Object[] buf;
    private int bufSize;
    private int insertSlot;
    private int removeSlot;
    private int entries;

    public Fifo() {
        this(16);
    }

    public Fifo(int initialSlots) {
        this.bufSize = initialSlots;
        this.buf = new Object[this.bufSize];
        this.insertSlot = 0;
        this.removeSlot = 0;
        this.entries = 0;
    }

    public synchronized boolean isEmpty() {
        return this.entries == 0;
    }

    public synchronized int size() {
        return this.entries;
    }

    public synchronized void insert(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (this.entries == this.bufSize) {
            int newBufSize = 2 * this.bufSize;
            Object[] newBuf = new Object[newBufSize];
            int saveEntries = this.entries;
            int i = 0;
            while (this.entries > 0) {
                newBuf[i] = this.remove();
                ++i;
            }
            this.entries = saveEntries;
            this.buf = newBuf;
            this.bufSize = newBufSize;
            this.removeSlot = 0;
            this.insertSlot = this.entries;
        }
        this.buf[this.insertSlot] = obj;
        this.insertSlot = (this.insertSlot + 1) % this.bufSize;
        ++this.entries;
    }

    public synchronized Object remove() {
        if (this.entries == 0) {
            return null;
        }
        Object o = this.buf[this.removeSlot];
        this.buf[this.removeSlot] = null;
        this.removeSlot = (this.removeSlot + 1) % this.bufSize;
        --this.entries;
        return o;
    }

    public synchronized void flush() {
        this.insertSlot = 0;
        this.removeSlot = 0;
        this.entries = 0;
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = null;
        }
    }
}

