/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.util.ConfigUtil;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class CommonAppVerifier {
    public static final String COMMONARCHIVES_PROP_FILE_NAME = "commonarchives.properties";
    public static final String EXCLUDE_KEY = "exclude.dir";
    private static Properties mapping;
    private static String[] keys;
    private static String[] excludes;
    private String relativeTestDir;
    private static boolean loaded;
    private static String distDir;
    private static CommonAppVerifier instance;

    private CommonAppVerifier() {
    }

    public static CommonAppVerifier getInstance(File path) {
        if (instance == null) {
            instance = new CommonAppVerifier();
        }
        instance.init(path);
        String pathString = path.getPath();
        distDir = pathString.substring(0, pathString.lastIndexOf("dist" + File.separator) + 5);
        return instance;
    }

    private void loadExcludes() {
        excludes = mapping == null ? TestUtil.EMPTY_STRING_ARRAY : ConfigUtil.stringToArray((String)mapping.remove(EXCLUDE_KEY));
    }

    private void init(File file) {
        if (!loaded) {
            mapping = ConfigUtil.loadPropertiesFor(COMMONARCHIVES_PROP_FILE_NAME);
            if (File.separator.equals("\\")) {
                TestUtil.logHarnessDebug("On Windows, so we must normalize the path returned from commonarchives.properties");
                Enumeration<?> e = mapping.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String val = mapping.getProperty(key);
                    mapping.setProperty(key, val.replace('/', File.separatorChar));
                }
            }
            this.loadExcludes();
            keys = ConfigUtil.loadKeysFrom(mapping);
            loaded = true;
        }
        if (mapping != null) {
            this.relativeTestDir = TestUtil.getRelativePath(file.getPath());
        }
    }

    private boolean isExcluded() {
        for (int i = 0; i < excludes.length; ++i) {
            if (!this.relativeTestDir.startsWith(excludes[i])) continue;
            TestUtil.logHarnessDebug("CommonAppVerifier:  This test dir is excluded from those listed in commonarchives.properties.");
            TestUtil.logHarnessDebug("CommonAppVerifier:  Please check your exclude list in the commonarchives.properties file.");
            return true;
        }
        return false;
    }

    public String[] getCommonApps() {
        System.err.println("getCommonApps - relativeTestDir = " + this.relativeTestDir);
        String[] result = mapping == null || keys == null || this.isExcluded() ? TestUtil.EMPTY_STRING_ARRAY : this.getMappingValue();
        return result;
    }

    private String[] getMappingValue() {
        String relativePath = "commonarchives." + this.relativeTestDir;
        for (int i = keys.length - 1; i >= 0; --i) {
            String keyLeafDir;
            String relativePathLeafDir;
            if (!relativePath.startsWith(keys[i]) || (relativePathLeafDir = relativePath.substring(relativePath.lastIndexOf("/"))).startsWith(keyLeafDir = keys[i].substring(keys[i].lastIndexOf("/"))) && !relativePathLeafDir.equals(keyLeafDir)) continue;
            return this.stringToArray(mapping.getProperty(keys[i]));
        }
        return TestUtil.EMPTY_STRING_ARRAY;
    }

    private String[] stringToArray(String s) {
        if (s == null) {
            return TestUtil.EMPTY_STRING_ARRAY;
        }
        StringTokenizer st = new StringTokenizer(s, " ,;\t\r\n\f");
        int tokenCount = st.countTokens();
        if (tokenCount == 0) {
            return TestUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[tokenCount];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i] = distDir + st.nextToken();
            ++i;
        }
        return result;
    }

    static {
        instance = new CommonAppVerifier();
    }
}

