/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class HandleDelegateClassLoader
extends ClassLoader {
    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(name);
        return c;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!name.equals("com.sun.enterprise.iiop.IIOPHandleDelegate")) {
            return super.loadClass(name, resolve);
        }
        Class<?> handleDelClass = this.findLoadedClass(name);
        if (handleDelClass != null) {
            return handleDelClass;
        }
        InputStream is = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ClassLoader resCl = Thread.currentThread().getContextClassLoader();
            if (Thread.currentThread().getContextClassLoader() == null) {
                resCl = HandleDelegateClassLoader.getSystemClassLoader();
            }
            is = resCl.getResourceAsStream("org/glassfish/enterprise/iiop/impl/IIOPHandleDelegate.class");
            byte[] buf = new byte[4096];
            int nread = 0;
            while ((nread = is.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, nread);
            }
            byte[] buf2 = baos.toByteArray();
            handleDelClass = this.defineClass("org.glassfish.enterprise.iiop.impl.IIOPHandleDelegate", buf2, 0, buf2.length);
        }
        catch (Exception ex) {
            throw (ClassNotFoundException)new ClassNotFoundException(ex.getMessage()).initCause(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (resolve) {
            this.resolveClass(handleDelClass);
        }
        return handleDelClass;
    }
}

