/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.threadpool;

import com.sun.corba.ee.impl.threadpool.ThreadPoolImpl;
import com.sun.corba.ee.impl.threadpool.WorkerThreadNotNeededException;
import com.sun.corba.ee.spi.threadpool.ThreadPool;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.threadpool.WorkQueue;
import java.util.LinkedList;
import java.util.Queue;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.NameValue;

public class WorkQueueImpl
implements WorkQueue {
    public static final String WORKQUEUE_DEFAULT_NAME = "default-workqueue";
    private final Queue<Work> queue;
    private ThreadPool workerThreadPool;
    private long workItemsAdded = 0L;
    private long workItemsDequeued = 0L;
    private long totalTimeInQueue = 0L;
    private final String name;

    public WorkQueueImpl() {
        this.name = WORKQUEUE_DEFAULT_NAME;
        this.queue = new LinkedList<Work>();
    }

    public WorkQueueImpl(ThreadPool workerThreadPool) {
        this(workerThreadPool, WORKQUEUE_DEFAULT_NAME);
    }

    public WorkQueueImpl(ThreadPool workerThreadPool, String name) {
        this.workerThreadPool = workerThreadPool;
        this.name = name;
        this.queue = new LinkedList<Work>();
    }

    private synchronized int getWorkQueueSize() {
        return this.queue.size();
    }

    @Override
    public synchronized void addWork(Work work) {
        ++this.workItemsAdded;
        work.setEnqueueTime(System.currentTimeMillis());
        this.queue.offer(work);
        this.notify();
        int waitingThreads = this.workerThreadPool.numberOfAvailableThreads();
        int threadCount = this.workerThreadPool.currentNumberOfThreads();
        int maxThreads = this.workerThreadPool.maximumNumberOfThreads();
        if (threadCount < maxThreads && waitingThreads < this.getWorkQueueSize()) {
            ((ThreadPoolImpl)this.workerThreadPool).createWorkerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Work requestWork(long waitTime) throws WorkerThreadNotNeededException, InterruptedException {
        Work work;
        try {
            ((ThreadPoolImpl)this.workerThreadPool).incrementNumberOfAvailableThreads();
            long startTime = Long.MAX_VALUE;
            while (this.queue.isEmpty()) {
                long now = System.currentTimeMillis();
                startTime = Math.min(now, startTime);
                long endTime = startTime + waitTime;
                long remainingWaitTime = endTime - now;
                if (remainingWaitTime <= 0L) {
                    break;
                }
                this.wait(remainingWaitTime);
            }
        }
        finally {
            ((ThreadPoolImpl)this.workerThreadPool).decrementNumberOfAvailableThreads();
        }
        if ((work = this.queue.poll()) == null) {
            int minThreads;
            int availableThreads = this.workerThreadPool.numberOfAvailableThreads() + 1;
            if (availableThreads > (minThreads = this.workerThreadPool.minimumNumberOfThreads())) {
                ((ThreadPoolImpl)this.workerThreadPool).decrementCurrentNumberOfThreads();
                throw new WorkerThreadNotNeededException();
            }
        } else {
            ++this.workItemsDequeued;
            this.totalTimeInQueue += System.currentTimeMillis() - work.getEnqueueTime();
        }
        return work;
    }

    @Override
    public synchronized void setThreadPool(ThreadPool workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    @Override
    public synchronized ThreadPool getThreadPool() {
        return this.workerThreadPool;
    }

    @Override
    @ManagedAttribute
    @Description(value="Total number of items added to the queue")
    public synchronized long totalWorkItemsAdded() {
        return this.workItemsAdded;
    }

    @Override
    @ManagedAttribute
    @Description(value="Total number of items in the queue to be processed")
    public synchronized int workItemsInQueue() {
        return this.queue.size();
    }

    @Override
    @ManagedAttribute
    @Description(value="Average time work items spend waiting in the queue in milliseconds")
    public synchronized long averageTimeInQueue() {
        if (this.workItemsDequeued == 0L) {
            return 0L;
        }
        return this.totalTimeInQueue / this.workItemsDequeued;
    }

    @Override
    @NameValue
    public String getName() {
        return this.name;
    }
}

