/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.provides;

import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ProxyForSameScope;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.UseProxy;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;

final class ProvidesDescriptor<T>
implements ActiveDescriptor<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final AnnotatedElement annotatedElement;
    private final Class<?> implementationClass;
    private final Type implementationType;
    private final Set<Type> contracts;
    private final Annotation scopeAnnotation;
    private final Function<ServiceHandle<?>, T> createFunction;
    private final Consumer<T> disposeFunction;
    private int ranking = 0;
    private boolean initialRankingFound = false;
    private T cache = null;
    private boolean isCacheSet = false;

    ProvidesDescriptor(AnnotatedElement annotatedElement, Class<?> implementationClass, Type implementationType, Set<Type> contracts, Annotation scopeAnnotation, Function<ServiceHandle<?>, T> createFunction, Consumer<T> disposeFunction) {
        this.annotatedElement = Objects.requireNonNull(annotatedElement);
        this.implementationClass = Objects.requireNonNull(implementationClass);
        this.implementationType = Objects.requireNonNull(implementationType);
        this.contracts = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(contracts)));
        this.scopeAnnotation = Objects.requireNonNull(scopeAnnotation);
        this.createFunction = Objects.requireNonNull(createFunction);
        this.disposeFunction = Objects.requireNonNull(disposeFunction);
    }

    public T create(ServiceHandle<?> root) {
        return this.createFunction.apply(root);
    }

    public void dispose(T instance) {
        this.disposeFunction.accept(instance);
    }

    public Class<?> getImplementationClass() {
        return this.implementationClass;
    }

    public Type getImplementationType() {
        return this.implementationType;
    }

    public Set<Type> getContractTypes() {
        return this.contracts;
    }

    public boolean isReified() {
        return true;
    }

    public Annotation getScopeAsAnnotation() {
        return this.scopeAnnotation;
    }

    public Class<? extends Annotation> getScopeAnnotation() {
        return this.getScopeAsAnnotation().annotationType();
    }

    public Set<Annotation> getQualifierAnnotations() {
        return Collections.unmodifiableSet(ReflectionHelper.getQualifierAnnotations((AnnotatedElement)this.annotatedElement));
    }

    public List<Injectee> getInjectees() {
        return Collections.emptyList();
    }

    public Long getFactoryServiceId() {
        return null;
    }

    public Long getFactoryLocatorId() {
        return null;
    }

    public String getImplementation() {
        return this.getImplementationClass().getName();
    }

    public Set<String> getAdvertisedContracts() {
        return this.getContractTypes().stream().map(contract -> ReflectionHelper.getRawClass((Type)contract)).filter(contractClass -> contractClass != null).map(contractClass -> contractClass.getName()).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> Collections.unmodifiableSet(set)));
    }

    public String getScope() {
        return this.getScopeAnnotation().getName();
    }

    public String getName() {
        return Arrays.stream(this.annotatedElement.getAnnotations()).filter(annotation -> annotation.annotationType() == Named.class).map(annotation -> (Named)annotation).map(annotation -> annotation.value()).findAny().orElse(null);
    }

    public Set<String> getQualifiers() {
        return this.getQualifierAnnotations().stream().map(annotation -> annotation.annotationType()).map(annotationType -> annotationType.getName()).collect(Collectors.collectingAndThen(Collectors.toSet(), set -> Collections.unmodifiableSet(set)));
    }

    public DescriptorType getDescriptorType() {
        return DescriptorType.CLASS;
    }

    public DescriptorVisibility getDescriptorVisibility() {
        return DescriptorVisibility.NORMAL;
    }

    public Map<String, List<String>> getMetadata() {
        HashMap<String, List> metadata = new HashMap<String, List>();
        Annotation scope = this.getScopeAsAnnotation();
        BuilderHelper.getMetadataValues((Annotation)scope, metadata);
        for (Annotation qualifier : this.getQualifierAnnotations()) {
            BuilderHelper.getMetadataValues((Annotation)qualifier, metadata);
        }
        metadata.replaceAll((key, values) -> Collections.unmodifiableList(values));
        return Collections.unmodifiableMap(metadata);
    }

    public HK2Loader getLoader() {
        return null;
    }

    public int getRanking() {
        this.lock.lock();
        try {
            if (!this.initialRankingFound) {
                Rank rank = this.annotatedElement.getAnnotation(Rank.class);
                if (rank != null) {
                    this.ranking = rank.value();
                }
                this.initialRankingFound = true;
            }
            int n = this.ranking;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setRanking(int ranking) {
        this.lock.lock();
        try {
            int previousRanking = this.getRanking();
            this.ranking = ranking;
            int n = previousRanking;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Boolean isProxiable() {
        UseProxy useProxy = this.annotatedElement.getAnnotation(UseProxy.class);
        return useProxy == null ? null : Boolean.valueOf(useProxy.value());
    }

    public Boolean isProxyForSameScope() {
        ProxyForSameScope proxyForSameScope = this.annotatedElement.getAnnotation(ProxyForSameScope.class);
        return proxyForSameScope == null ? null : Boolean.valueOf(proxyForSameScope.value());
    }

    public String getClassAnalysisName() {
        return null;
    }

    public Long getServiceId() {
        return null;
    }

    public Long getLocatorId() {
        return null;
    }

    public T getCache() {
        this.lock.lock();
        try {
            if (!this.isCacheSet) {
                throw new IllegalStateException();
            }
            T t = this.cache;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCacheSet() {
        this.lock.lock();
        try {
            boolean bl = this.isCacheSet;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCache(T cacheMe) {
        this.lock.lock();
        try {
            this.cache = cacheMe;
            this.isCacheSet = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void releaseCache() {
        this.lock.lock();
        try {
            this.cache = null;
            this.isCacheSet = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.annotatedElement + "]";
    }
}

