/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edapt.common.ui.ModelSash;
import org.eclipse.emf.edapt.common.ui.StructureTreeViewer;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.MetamodelResource;
import org.eclipse.emf.edapt.migration.Model;
import org.eclipse.emf.edapt.migration.ModelResource;
import org.eclipse.emf.edapt.migration.Repository;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class MigrationModelSash
extends ModelSash {
    public MigrationModelSash(Composite parent, int style, AdapterFactory adapterFactory) {
        super(parent, style, adapterFactory);
        StructureTreeViewer modelViewer = this.getStructureViewer();
        modelViewer.setContentProvider((IContentProvider)new MigrationContentProvider(adapterFactory));
        modelViewer.setSorter(null);
    }

    private class MigrationContentProvider
    extends AdapterFactoryContentProvider {
        private Repository repository;

        public MigrationContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getChildren(Object object) {
            if (object instanceof Model) {
                Model model = (Model)object;
                return model.getResources().toArray();
            }
            if (object instanceof ModelResource) {
                ModelResource resource = (ModelResource)object;
                return resource.getRootInstances().toArray();
            }
            if (object instanceof MetamodelResource) {
                MetamodelResource resource = (MetamodelResource)object;
                return resource.getRootPackages().toArray();
            }
            return super.getChildren(object);
        }

        public boolean hasChildren(Object object) {
            if (object instanceof Model) {
                Model model = (Model)object;
                return !model.getResources().isEmpty();
            }
            if (object instanceof ModelResource) {
                ModelResource resource = (ModelResource)object;
                return !resource.getRootInstances().isEmpty();
            }
            if (object instanceof MetamodelResource) {
                MetamodelResource resource = (MetamodelResource)object;
                return !resource.getRootPackages().isEmpty();
            }
            return super.hasChildren(object);
        }

        public Object getParent(Object object) {
            EPackage ePackage;
            if (object instanceof Instance) {
                Instance instance = (Instance)object;
                if (instance.getContainer() == null) {
                    return instance.getResource();
                }
                return instance.getContainer();
            }
            if (object instanceof EPackage && (ePackage = (EPackage)object).getESuperPackage() == null) {
                for (MetamodelResource resource : this.repository.getMetamodel().getResources()) {
                    if (!resource.getRootPackages().contains((Object)ePackage)) continue;
                    return resource;
                }
            }
            return super.getParent(object);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.repository = (Repository)newInput;
            super.inputChanged(viewer, oldInput, newInput);
        }
    }
}

