/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.history.recorder.ui.CreateHistoryCommand;
import org.eclipse.emf.edapt.internal.common.MetamodelUtils;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class CreateHistoryWizard
extends Wizard {
    private final EcoreEditor editor;
    private HistoryWizardNewFileCreationPage newFileCreationPage;
    private MetamodelResourceSelectionWizardPage metamodelsResourceSelectionPage;

    public CreateHistoryWizard(EcoreEditor editor) {
        this.editor = editor;
        this.setWindowTitle("Create History");
    }

    public void addPages() {
        this.newFileCreationPage = new HistoryWizardNewFileCreationPage(this.editor);
        this.addPage((IWizardPage)this.newFileCreationPage);
        this.metamodelsResourceSelectionPage = new MetamodelResourceSelectionWizardPage(this.editor);
        if (this.metamodelsResourceSelectionPage.isRequired()) {
            this.addPage((IWizardPage)this.metamodelsResourceSelectionPage);
        }
    }

    public boolean performFinish() {
        List<Resource> metamodelResources = this.metamodelsResourceSelectionPage.getMetamodelResources();
        URI historyURI = URIUtils.getURI((IResource)this.newFileCreationPage.getHistoryFile());
        CreateHistoryCommand command = new CreateHistoryCommand(this.editor, metamodelResources, historyURI);
        this.editor.getEditingDomain().getCommandStack().execute((Command)command);
        return true;
    }

    private static class HistoryWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public HistoryWizardNewFileCreationPage(EcoreEditor editor) {
            super("NewHistoryFile", (IStructuredSelection)new StructuredSelection((Object)HistoryWizardNewFileCreationPage.getFile(editor).getParent()));
            this.setFileExtension("history");
            this.setFileName(HistoryWizardNewFileCreationPage.getFile(editor).getLocation().removeFileExtension().addFileExtension("history").lastSegment());
            this.setTitle("File");
            this.setDescription("Choose the location and name of the history file.");
        }

        public IFile getHistoryFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }

        private static IFile getFile(EcoreEditor editor) {
            return ((IFileEditorInput)editor.getEditorInput()).getFile();
        }
    }

    private static class MetamodelResourceSelectionWizardPage
    extends WizardPage {
        private Resource mainMetamodelResource;
        private List<Resource> otherMetamodelResources;
        private final EcoreEditor editor;
        private AdapterFactoryLabelProvider labelProvider;
        private CheckboxTableViewer tableViewer;

        public MetamodelResourceSelectionWizardPage(EcoreEditor editor) {
            super("SelectMetamodelResources");
            this.editor = editor;
            this.setTitle("Metamodel Resources");
            this.setDescription("Choose the other metamodel resources that should be recorded.");
        }

        public void createControl(Composite parent) {
            this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
            this.labelProvider = new AdapterFactoryLabelProvider(this.editor.getAdapterFactory());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.tableViewer.setInput(this.otherMetamodelResources);
            this.tableViewer.setAllChecked(true);
            this.setControl(this.tableViewer.getControl());
        }

        public boolean isRequired() {
            EcoreUtil.resolveAll((ResourceSet)this.editor.getEditingDomain().getResourceSet());
            this.otherMetamodelResources = new ArrayList<Resource>();
            for (Resource resource : this.editor.getEditingDomain().getResourceSet().getResources()) {
                if (!MetamodelUtils.isMetamodelResource((Resource)resource)) continue;
                if (this.mainMetamodelResource == null) {
                    this.mainMetamodelResource = resource;
                    continue;
                }
                this.otherMetamodelResources.add(resource);
            }
            return !this.otherMetamodelResources.isEmpty();
        }

        public List<Resource> getMetamodelResources() {
            if (this.tableViewer == null) {
                return Collections.singletonList(this.mainMetamodelResource);
            }
            Object[] results = this.tableViewer.getCheckedElements();
            ArrayList<Resource> metamodelResources = new ArrayList<Resource>();
            metamodelResources.add(this.mainMetamodelResource);
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                if (result instanceof Resource) {
                    metamodelResources.add((Resource)result);
                }
                ++n2;
            }
            return metamodelResources;
        }

        public void dispose() {
            super.dispose();
            this.labelProvider.dispose();
        }
    }
}

