/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.cdo.internal.core;

import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public final class CDORepositoryData
implements CDOSessionConfigurationFactory {
    private final InternalRepository repository;

    public CDORepositoryData(InternalRepository repository) {
        this.repository = repository;
    }

    public InternalRepository getRepository() {
        return this.repository;
    }

    public CDONet4jSessionConfiguration createSessionConfiguration() {
        ECPProperties properties = this.repository.getProperties();
        String connectorType = properties.getValue("connectorType");
        String connectorDescription = properties.getValue("connectorDescription");
        String repositoryName = properties.getValue("repositoryName");
        IConnector connector = Net4jUtil.getConnector((IManagedContainer)IPluginContainer.INSTANCE, (String)connectorType, (String)connectorDescription);
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector(connector);
        configuration.setRepositoryName(repositoryName);
        return configuration;
    }

    public String toString() {
        ECPProperties properties = this.repository.getProperties();
        String connectorType = properties.getValue("connectorType");
        String connectorDescription = properties.getValue("connectorDescription");
        String repositoryName = properties.getValue("repositoryName");
        return String.valueOf(connectorType) + "://" + connectorDescription + "/" + repositoryName;
    }
}

