/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.creation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.MetamodelFactory;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="newReference", label="Create Reference", description="In the metamodel, a new reference is created. Nothing is changed in the model.", breaking=false)
public class NewReference
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class in which the reference is created")
    public EClass eClass;
    @EdaptParameter(description="The name of the new reference")
    public String name;
    @EdaptParameter(description="The type of the new reference")
    public EClass type;
    @EdaptParameter(description="The lower bound of the new reference")
    public int lowerBound = 0;
    @EdaptParameter(description="The upper bound of the new reference")
    public int upperBound = 1;
    @EdaptParameter(description="Whether the new reference is a containment reference")
    public Boolean containment = false;
    @EdaptParameter(description="The opposite reference of the new reference", optional=true)
    public EReference opposite;

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EReference reference = MetamodelFactory.newEReference((EClass)this.eClass, (String)this.name, (EClass)this.type, (int)this.lowerBound, (int)this.upperBound, (boolean)this.containment);
        if (this.opposite != null) {
            metamodel.setEOpposite(this.opposite, reference);
        }
    }
}

