/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.internal.migration;

import org.eclipse.emf.ecp.ide.internal.migration.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ViewMigrationDialog
extends TitleAreaDialog {
    private Text updatedNamespaceText;
    private Text currentNamespaceText;
    private String oldNamespaceFragment;
    private String newNamespaceFragment;
    private Button showWarningsButton;
    private boolean showWarnings;

    public ViewMigrationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ViewMigrationDialog_ShellTitle);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.UpdateNSDialog_MigrationDialogTitle);
        this.setMessage(Messages.UpdateNSDialog_MigrationDialog_Message, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.ViewMigrationDialog_LabelText);
        this.currentNamespaceText = this.createInput(container, Messages.ViewMigrationDialog_CurrentNSLabel);
        this.updatedNamespaceText = this.createInput(container, Messages.ViewMigrationDialog_UpdatedNSLabel);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.showWarningsButton = new Button(container, 32);
        this.showWarningsButton.setText(Messages.ViewMigrationDialog_ShowWarnings);
        this.showWarningsButton.setSelection(true);
        return area;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected boolean isResizable() {
        return true;
    }

    private Text createInput(Composite container, String labelText) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        Text text = new Text(container, 2048);
        text.setLayoutData((Object)layoutData);
        return text;
    }

    protected void okPressed() {
        this.oldNamespaceFragment = this.currentNamespaceText.getText();
        this.newNamespaceFragment = this.updatedNamespaceText.getText();
        this.showWarnings = this.showWarningsButton.getSelection();
        super.okPressed();
    }

    public String getOldNamespaceFragment() {
        return this.oldNamespaceFragment;
    }

    public String getNewNamespaceFragment() {
        return this.newNamespaceFragment;
    }

    public boolean shouldShowWarning() {
        return this.showWarnings;
    }
}

