/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.celleditor.rcp;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCustomUpdateCellEditor;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.table.celleditor.rcp.NativeWidgetHelper;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class BooleanCellEditor
extends CellEditor
implements ECPCellEditor,
ECPCustomUpdateCellEditor {
    private boolean editable;
    private final Composite parent;
    private boolean value;

    public BooleanCellEditor(Composite parent) {
        super(parent);
        this.parent = parent;
    }

    public IValueProperty getValueProperty() {
        return new WidgetValueProperty(){

            public Object getValueType() {
                return Boolean.class;
            }

            protected Object doGetValue(Object source) {
                return BooleanCellEditor.this.doGetValue();
            }

            protected void doSetValue(Object source, Object value) {
                BooleanCellEditor.this.doSetValue(value);
            }

            public IObservableValue observe(Object source) {
                return new BooleanCellEditorObservableValue();
            }
        };
    }

    public void instantiate(EStructuralFeature feature, ViewModelContext viewModelContext) {
    }

    public String getFormatedString(Object value) {
        return null;
    }

    public int getColumnWidthWeight() {
        return 25;
    }

    public UpdateValueStrategy getTargetToModelStrategy(DataBindingContext databindingContext) {
        return new EMFUpdateValueStrategy();
    }

    public UpdateValueStrategy getModelToTargetStrategy(DataBindingContext databindingContext) {
        return new EMFUpdateValueStrategy();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public Image getImage(Object value) {
        NativeWidgetHelper.CheckBoxState state = (Boolean)value != false ? NativeWidgetHelper.CheckBoxState.checked : NativeWidgetHelper.CheckBoxState.unchecked;
        return NativeWidgetHelper.getCheckBoxImage((Control)this.parent, state);
    }

    public void activate() {
        if (this.editable) {
            this.value = !this.value;
            this.fireApplyEditorValue();
        }
    }

    protected Control createControl(Composite parent) {
        return null;
    }

    protected Object doGetValue() {
        return this.value ? Boolean.TRUE : Boolean.FALSE;
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((boolean)(value instanceof Boolean));
        this.value = (Boolean)value;
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        if (activationEvent.eventType != 5) {
            super.activate(activationEvent);
        }
    }

    public void updateCell(ViewerCell cell, Object value) {
        if (!"".equals(cell.getText())) {
            cell.setText("");
        }
        Image image = this.getImage(value);
        if (cell.getImage() != image) {
            cell.setImage(image);
        }
        this.setCopyTextMarker(cell, value);
    }

    protected void setCopyTextMarker(ViewerCell cell, Object value) {
        if (value != null) {
            Widget item = cell.getItem();
            Map<Integer, String> copyMap = this.getCopyMap(item);
            copyMap.put(cell.getColumnIndex(), value.toString());
        }
    }

    protected Map<Integer, String> getCopyMap(Widget widget) {
        HashMap copyMap = (HashMap)widget.getData("org.eclipse.emf.ecp.edit.spi.swt.table.copyStringAlternative");
        if (copyMap == null) {
            copyMap = new HashMap();
            widget.setData("org.eclipse.emf.ecp.edit.spi.swt.table.copyStringAlternative", copyMap);
        }
        return copyMap;
    }

    public int getMinWidth() {
        return 0;
    }

    private class BooleanCellEditorObservableValue
    extends AbstractObservableValue {
        private final ICellEditorListener listener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
                BooleanCellEditorObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)((Boolean)Boolean.class.cast(BooleanCellEditor.this.getValue()) == false ? 1 : 0), (Object)BooleanCellEditor.this.getValue()));
            }
        };

        BooleanCellEditorObservableValue() {
            BooleanCellEditor.this.addListener(this.listener);
        }

        public Object getValueType() {
            return Boolean.class;
        }

        protected Object doGetValue() {
            return BooleanCellEditor.this.getValue();
        }

        protected void doSetValue(Object value) {
            BooleanCellEditor.this.setValue(value);
        }

        public synchronized void dispose() {
            BooleanCellEditor.this.removeListener(this.listener);
            super.dispose();
        }
    }
}

