/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.print;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelperUtil;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.JPSDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.PageData;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeTypes;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.graphics.GraphicsToGraphics2DAdaptor;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextUtilitiesEx;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class SiriusJPSRenderedDiagramPrinter
extends JPSDiagramPrinter {
    private static final double AWT_DPI_CONST = 72.0;
    private PrintService printService;
    private Boolean isAwtPluginBeforeLunaVersion;

    public SiriusJPSRenderedDiagramPrinter(PreferencesHint preferencesHint, IMapMode mm) {
        super(preferencesHint, mm);
    }

    public void setPrinter(String printerName) {
        HashPrintServiceAttributeSet attributes = new HashPrintServiceAttributeSet(new PrinterName(printerName, Locale.getDefault()));
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, attributes);
        this.printService = services[0];
    }

    public void run() {
        Iterator it = this.diagrams.iterator();
        Shell shell = new Shell();
        try {
            while (it.hasNext()) {
                IPreferenceStore preferenceStore;
                Diagram diagram = (Diagram)it.next();
                DiagramEditor openedDiagramEditor = this.getDiagramEditor(diagram);
                DiagramEditPart dgrmEP = openedDiagramEditor == null ? PrintHelperUtil.createDiagramEditPart((Diagram)diagram, (PreferencesHint)this.preferencesHint, (Shell)shell) : openedDiagramEditor.getDiagramEditPart();
                boolean loadedPreferences = openedDiagramEditor != null || PrintHelperUtil.initializePreferences((DiagramEditPart)dgrmEP, (PreferencesHint)this.preferencesHint);
                RootEditPart rep = dgrmEP.getRoot();
                if (rep instanceof DiagramRootEditPart) {
                    this.mapMode = ((DiagramRootEditPart)rep).getMapMode();
                }
                if ((preferenceStore = ((DiagramGraphicalViewer)dgrmEP.getViewer()).getWorkspaceViewerPreferenceStore()).getBoolean("print.useWorkspaceSettings") && dgrmEP.getDiagramPreferencesHint().getPreferenceStore() != null) {
                    preferenceStore = (IPreferenceStore)dgrmEP.getDiagramPreferencesHint().getPreferenceStore();
                }
                this.doPrintDiagram(this.printService.createPrintJob(), dgrmEP, loadedPreferences, preferenceStore);
            }
        }
        finally {
            this.dispose();
            shell.dispose();
        }
    }

    private DiagramEditor getDiagramEditor(Diagram diagram) {
        DiagramEditor result = null;
        List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : diagramEditors) {
            DiagramEditor diagramEditor;
            if (!(obj instanceof DiagramEditor) || (diagramEditor = (DiagramEditor)obj).getDiagram() != diagram) continue;
            result = diagramEditor;
            break;
        }
        return result;
    }

    public int print(java.awt.Graphics printGraphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.isAwtPluginBeforeLunaVersion()) {
            return this.printPreviousLuna(printGraphics, pageFormat, pageIndex);
        }
        return super.print(printGraphics, pageFormat, pageIndex);
    }

    protected boolean isAwtPluginBeforeLunaVersion() {
        if (this.isAwtPluginBeforeLunaVersion == null) {
            Version lunaVersion = Version.parseVersion((String)"1.8.0");
            Bundle awtBundle = Platform.getBundle((String)"org.eclipse.gmf.runtime.draw2d.ui.render.awt");
            this.isAwtPluginBeforeLunaVersion = awtBundle != null ? Boolean.valueOf(awtBundle.getVersion().compareTo(lunaVersion) < 0) : Boolean.valueOf(false);
        }
        return this.isAwtPluginBeforeLunaVersion;
    }

    public int printPreviousLuna(java.awt.Graphics printGraphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Option optionPages = ReflectionHelper.getFieldValueWithoutException((Object)((Object)this), (String)"pages");
        if (!optionPages.some() || pageIndex >= ((PageData[])optionPages.get()).length) {
            return 1;
        }
        try {
            printGraphics.setClip(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
            this.swtGraphics = new PrinterGraphicsToGraphics2DAdapter((Graphics2D)printGraphics, new Rectangle(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight()));
            this.graphics = this.createMapModeGraphics((Graphics)this.createPrinterGraphics(this.swtGraphics));
            this.graphics.scale(72.0 / (double)this.display_dpi.x);
            this.drawPage(((PageData[])optionPages.get())[pageIndex]);
        }
        finally {
            this.dispose();
        }
        return 0;
    }

    private class PrinterGraphicsToGraphics2DAdapter
    extends GraphicsToGraphics2DAdaptor {
        private final TextUtilitiesEx textUtilities;

        PrinterGraphicsToGraphics2DAdapter(Graphics2D graphics, Rectangle viewPort) {
            super(graphics, viewPort);
            this.textUtilities = new TextUtilitiesEx(MapModeTypes.IDENTITY_MM);
        }

        public void setLineWidth(int width) {
            super.setLineWidth(width);
            BasicStroke scaledStroke = this.getStroke();
            scaledStroke = new BasicStroke((float)((double)width * 72.0 / 100.0), scaledStroke.getEndCap(), scaledStroke.getLineJoin(), scaledStroke.getMiterLimit(), scaledStroke.getDashArray(), 0.0f);
            this.getGraphics2D().setStroke(scaledStroke);
        }

        public void fillGradient(int x, int y, int w, int h, boolean vertical) {
            Image tempImage = new Image((Device)DisplayUtils.getDisplay(), new org.eclipse.swt.graphics.Rectangle(x, y, w, h));
            GC gc = new GC((Drawable)tempImage);
            SWTGraphics tempGraphics = new SWTGraphics(gc);
            tempGraphics.setForegroundColor(SiriusJPSRenderedDiagramPrinter.this.swtGraphics.getForegroundColor());
            tempGraphics.setBackgroundColor(SiriusJPSRenderedDiagramPrinter.this.swtGraphics.getBackgroundColor());
            tempGraphics.fillGradient(new Rectangle(0, 0, w, h), vertical);
            this.drawImage(tempImage, 0, 0, w, h, x, y, w, h);
            tempGraphics.dispose();
            gc.dispose();
            tempImage.dispose();
        }

        private boolean isFontUnderlined(Font f) {
            return false;
        }

        private boolean isFontStrikeout(Font f) {
            return false;
        }

        public void drawString(String s, int x, int y) {
            int lineWidth;
            Option optionalTransX = ReflectionHelper.getFieldValueWithoutException((Object)((Object)this), (String)"transX");
            Option optionalTransY = ReflectionHelper.getFieldValueWithoutException((Object)((Object)this), (String)"transY");
            if (s == null || s.length() == 0 || !optionalTransX.some() || !optionalTransY.some()) {
                return;
            }
            FontMetrics metrics = this.getGraphics2D().getFontMetrics();
            int stringLength = metrics.stringWidth(s);
            Dimension swtStringSize = this.textUtilities.getStringExtents(s, SiriusJPSRenderedDiagramPrinter.this.swtGraphics.getFont());
            float xpos = x + (Integer)optionalTransX.get();
            float ypos = y + (Integer)optionalTransY.get();
            if (this.paintNotCompatibleStringsAsBitmaps && this.getGraphics2D().getFont().canDisplayUpTo(s) != -1) {
                Image image = new Image((Device)DisplayUtils.getDisplay(), swtStringSize.width, swtStringSize.height);
                GC gc = new GC((Drawable)image);
                gc.setForeground(this.getForegroundColor());
                gc.setBackground(this.getBackgroundColor());
                gc.setAntialias(this.getAntialias());
                gc.setFont(this.getFont());
                gc.drawString(s, 0, 0);
                gc.dispose();
                ImageData data = image.getImageData();
                image.dispose();
                RGB backgroundRGB = this.getBackgroundColor().getRGB();
                int i = 0;
                while (i < data.width) {
                    int j = 0;
                    while (j < data.height) {
                        if (data.palette.getRGB(data.getPixel(i, j)).equals((Object)backgroundRGB)) {
                            data.setAlpha(i, j, 0);
                        } else {
                            data.setAlpha(i, j, 255);
                        }
                        ++j;
                    }
                    ++i;
                }
                this.checkState();
                this.getGraphics2D().drawImage(ImageConverter.convertFromImageData((ImageData)data), new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, xpos, ypos), null);
                stringLength = swtStringSize.width;
            } else {
                this.checkState();
                this.getGraphics2D().setPaint(this.getColor(SiriusJPSRenderedDiagramPrinter.this.swtGraphics.getForegroundColor()));
                this.getGraphics2D().drawString(s, xpos, ypos += (float)metrics.getAscent());
            }
            if (this.isFontUnderlined(this.getFont())) {
                int baseline = y + metrics.getAscent();
                lineWidth = this.getLineWidth();
                this.setLineWidth(1);
                this.drawLine(x, baseline, x + stringLength, baseline);
                this.setLineWidth(lineWidth);
            }
            if (this.isFontStrikeout(this.getFont())) {
                int strikeline = y + metrics.getHeight() / 2;
                lineWidth = this.getLineWidth();
                this.setLineWidth(1);
                this.drawLine(x, strikeline, x + stringLength, strikeline);
                this.setLineWidth(lineWidth);
            }
        }
    }
}

