/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.decoration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Decoration;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.UIState;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.DecorationDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.GenericDecorationDescription;
import org.eclipse.sirius.viewpoint.description.SemanticBasedDecoration;

public final class DecorationHelperInternal {
    private IInterpreter interpreter;
    private DDiagram diagram;
    private ModelAccessor accessor;

    public DecorationHelperInternal(DDiagram diagram, IInterpreter interpreter, ModelAccessor accessor) {
        this.diagram = diagram;
        this.interpreter = interpreter;
        this.accessor = accessor;
    }

    public DecorationHelperInternal(DDiagram diagram) {
        this.diagram = diagram;
        this.interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)diagram);
        this.accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)diagram);
    }

    public void addDecoration(DDiagramElement element, DecorationDescription decorationDescription) {
        for (Decoration decoration : element.getDecorations()) {
            if (!EcoreUtil.equals((EObject)decorationDescription, (EObject)decoration.getDescription())) continue;
            return;
        }
        for (Decoration decoration : element.getTransientDecorations()) {
            if (!EcoreUtil.equals((EObject)decorationDescription, (EObject)decoration.getDescription())) continue;
            return;
        }
        if (this.checkDecoratorPrecondition(element.getTarget(), (DSemanticDecorator)element.eContainer(), decorationDescription)) {
            Decoration decoration;
            decoration = ViewpointFactory.eINSTANCE.createDecoration();
            decoration.setDescription(decorationDescription);
            if (LayerHelper.isTransientLayer((Layer)decorationDescription.eContainer().eContainer())) {
                element.getTransientDecorations().add((Object)decoration);
            } else {
                element.getDecorations().add((Object)decoration);
            }
        }
    }

    private boolean checkDecoratorCondition(DDiagramElement element, DecorationDescription decorationDescription) {
        Boolean result = decorationDescription instanceof GenericDecorationDescription;
        result = result != false || decorationDescription instanceof MappingBasedDecoration && ((MappingBasedDecoration)decorationDescription).getMappings().contains((Object)element.getDiagramElementMapping());
        result = result != false || decorationDescription instanceof SemanticBasedDecoration && this.accessor.eInstanceOf(element.getTarget(), ((SemanticBasedDecoration)decorationDescription).getDomainClass());
        return result;
    }

    private boolean checkDecoratorPrecondition(EObject semantic, DSemanticDecorator container, DecorationDescription decorationDescription) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.CHECK_PRECONDITION_KEY);
        boolean result = false;
        if (decorationDescription != null && !decorationDescription.eIsProxy()) {
            result = true;
            String preconditionExpression = decorationDescription.getPreconditionExpression();
            if (!StringUtil.isEmpty((String)preconditionExpression)) {
                this.interpreter.setVariable("containerView", (Object)container);
                this.interpreter.setVariable("container", (Object)(container != null ? container.getTarget() : null));
                this.interpreter.setVariable("viewpoint", (Object)this.diagram);
                this.interpreter.setVariable("diagram", (Object)this.diagram);
                try {
                    result = this.interpreter.evaluateBoolean(semantic, preconditionExpression);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)decorationDescription, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDecorationDescription_PreconditionExpression(), (Throwable)e);
                }
                this.interpreter.unSetVariable("containerView");
                this.interpreter.unSetVariable("container");
                this.interpreter.unSetVariable("viewpoint");
                this.interpreter.unSetVariable("diagram");
            }
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CHECK_PRECONDITION_KEY);
        return result;
    }

    private void computeDecoration(GenericDecorationDescription decorationDescription, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        for (Collection<EdgeTarget> collection : mappingsToEdgeTargets.values()) {
            for (DDiagramElement element : Iterables.filter(collection, DDiagramElement.class)) {
                this.addDecoration(element, (DecorationDescription)decorationDescription);
            }
        }
    }

    private void computeDecoration(MappingBasedDecoration decorationDescription, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration) {
        for (DiagramElementMapping mapping : decorationDescription.getMappings()) {
            if (mapping instanceof AbstractNodeMapping) {
                Collection<EdgeTarget> targets = mappingsToEdgeTargets.get(mapping);
                if (targets == null) continue;
                for (DDiagramElement element : Iterables.filter(targets, DDiagramElement.class)) {
                    this.addDecoration(element, decorationDescription);
                }
                continue;
            }
            if (!(mapping instanceof EdgeMapping)) continue;
            if (!edgeToMappingBasedDecoration.containsKey(mapping)) {
                edgeToMappingBasedDecoration.put((EdgeMapping)mapping, new HashSet());
            }
            edgeToMappingBasedDecoration.get(mapping).add(decorationDescription);
        }
    }

    private void computeDecoration(SemanticBasedDecoration decorationDescription, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration) {
        String domainClass = decorationDescription.getDomainClass();
        for (Collection<EdgeTarget> collection : mappingsToEdgeTargets.values()) {
            for (DDiagramElement element : Iterables.filter(collection, DDiagramElement.class)) {
                if (!this.accessor.eInstanceOf(element.getTarget(), decorationDescription.getDomainClass())) continue;
                this.addDecoration(element, (DecorationDescription)decorationDescription);
            }
        }
        if (!edgeToSemanticBasedDecoration.containsKey(domainClass)) {
            edgeToSemanticBasedDecoration.put(domainClass, new HashSet());
        }
        edgeToSemanticBasedDecoration.get(domainClass).add(decorationDescription);
    }

    public void computeDecorations(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration) {
        ArrayList activatedLayers = Lists.newArrayList();
        activatedLayers.addAll(this.diagram.getActivatedLayers());
        activatedLayers.addAll(this.diagram.getActivatedTransientLayers());
        for (Layer layer : activatedLayers) {
            if (layer.getDecorationDescriptionsSet() == null || layer.getDecorationDescriptionsSet().getDecorationDescriptions().size() <= 0) continue;
            for (DecorationDescription decorationDescription : layer.getDecorationDescriptionsSet().getDecorationDescriptions()) {
                if (decorationDescription instanceof MappingBasedDecoration) {
                    this.computeDecoration((MappingBasedDecoration)decorationDescription, mappingsToEdgeTargets, edgeToMappingBasedDecoration);
                    continue;
                }
                if (decorationDescription instanceof SemanticBasedDecoration) {
                    this.computeDecoration((SemanticBasedDecoration)decorationDescription, mappingsToEdgeTargets, edgeToSemanticBasedDecoration);
                    continue;
                }
                if (!(decorationDescription instanceof GenericDecorationDescription)) continue;
                this.computeDecoration((GenericDecorationDescription)decorationDescription, mappingsToEdgeTargets);
            }
        }
    }

    public void deleteOrResetDecoration(DDiagramElement element, List<Decoration> decorations, List<? extends Layer> activatedLayers) {
        Iterator<Decoration> it = decorations.iterator();
        while (it.hasNext()) {
            Decoration decoration = it.next();
            DecorationDescription description = decoration.getDescription();
            if (!activatedLayers.contains(LayerHelper.getParentLayer(description)) || !this.checkDecoratorPrecondition(element.getTarget(), (DSemanticDecorator)element.eContainer(), description)) {
                it.remove();
                continue;
            }
            DRepresentation parentRepresentation = new DRepresentationElementQuery((DRepresentationElement)element).getParentRepresentation();
            if (parentRepresentation == null) continue;
            UIState uiState = parentRepresentation.getUiState();
            uiState.getDecorationImage().remove(decoration);
        }
    }

    public void updateDecoration(DDiagramElement element) {
        this.deleteOrResetDecoration(element, (List<Decoration>)element.getDecorations(), (List<? extends Layer>)this.diagram.getActivatedLayers());
        this.deleteOrResetDecoration(element, (List<Decoration>)element.getTransientDecorations(), (List<? extends Layer>)this.diagram.getActivatedTransientLayers());
        ArrayList layers = Lists.newArrayList((Iterable)Iterables.concat(this.diagram.getActivatedLayers(), this.diagram.getActivatedTransientLayers()));
        for (Layer layer : layers) {
            this.updateDecorationToAdd(element, layer);
        }
    }

    public void updateDecorationToAdd(DDiagramElement element, Layer layer) {
        if (layer.getDecorationDescriptionsSet() != null) {
            EList decorationDescriptions = layer.getDecorationDescriptionsSet().getDecorationDescriptions();
            for (DecorationDescription decorationDescription : decorationDescriptions) {
                if (!this.checkDecoratorCondition(element, decorationDescription)) continue;
                this.addDecoration(element, decorationDescription);
            }
        }
    }
}

