/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.Optional;
import org.eclipse.eef.EEFToolbarAction;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IEEFToolbarActionController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.EEFImageUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.graphics.Image;

public class ToolbarAction
extends Action {
    private EEFToolbarAction eefToolbarAction;
    private IEEFToolbarActionController controller;
    private EditingContextAdapter editingContextAdapter;
    private IInterpreter interpreter;
    private IVariableManager variableManager;

    public ToolbarAction(EEFToolbarAction eefToolbarAction, IEEFToolbarActionController controller, EditingContextAdapter editingContextAdapter, IInterpreter interpreter, IVariableManager variableManager) {
        super(null, 1);
        this.eefToolbarAction = eefToolbarAction;
        this.controller = controller;
        this.editingContextAdapter = editingContextAdapter;
        this.interpreter = interpreter;
        this.variableManager = variableManager;
        String tooltipExpression = eefToolbarAction.getTooltipExpression();
        String actionTooltip = (String)EvalFactory.of((IInterpreter)interpreter, (IVariableManager)variableManager).logIfInvalidType(String.class).evaluate(tooltipExpression);
        this.setToolTipText(actionTooltip);
        String imageExpression = Optional.ofNullable(this.eefToolbarAction.getImageExpression()).orElse("");
        Object imagePath = EvalFactory.of((IInterpreter)interpreter, (IVariableManager)variableManager).logIfInvalidType(Object.class).evaluate(imageExpression);
        Optional.ofNullable(imagePath).filter(String.class::isInstance).map(String.class::cast).map(this::computeImageDescriptor).ifPresent(arg_0 -> ((ToolbarAction)this).setImageDescriptor(arg_0));
    }

    private ImageDescriptor computeImageDescriptor(String imagePath) {
        return EEFImageUtils.getImageDescriptor(imagePath).orElseGet(() -> {
            Image placeholderImage = EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/placeholder.gif");
            return ImageDescriptor.createFromImage((Image)placeholderImage);
        });
    }

    public void run() {
        this.controller.action(this.eefToolbarAction, this.editingContextAdapter, this.interpreter, this.variableManager);
    }
}

