/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.core.launching;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.eclemma.internal.core.launching.AdjustedLaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

class AdjustedLaunchConfiguration
implements ILaunchConfiguration {
    private static final String KEY = IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS;
    private final ILaunchConfiguration delegate;
    private final String extraVMArgument;

    public AdjustedLaunchConfiguration(String extraVMArgument, ILaunchConfiguration delegate) {
        this.extraVMArgument = extraVMArgument;
        this.delegate = delegate;
    }

    public boolean hasAttribute(String attributeName) throws CoreException {
        return KEY.equals(attributeName) || this.delegate.hasAttribute(attributeName);
    }

    public String getAttribute(String attributeName, String defaultValue) throws CoreException {
        if (KEY.equals(attributeName)) {
            return this.getVMArguments();
        }
        return this.delegate.getAttribute(attributeName, defaultValue);
    }

    public Map getAttributes() throws CoreException {
        HashMap<String, String> map = new HashMap<String, String>(this.delegate.getAttributes());
        map.put(KEY, this.getVMArguments());
        return map;
    }

    private String getVMArguments() throws CoreException {
        String original = this.delegate.getAttribute(KEY, "");
        if (original.length() > 0) {
            return String.valueOf(this.extraVMArgument) + ' ' + original;
        }
        return this.extraVMArgument;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public ILaunchConfigurationWorkingCopy copy(String name) throws CoreException {
        return new AdjustedLaunchConfigurationWorkingCopy(this.extraVMArgument, this.delegate.copy(name), null);
    }

    public ILaunchConfigurationWorkingCopy getWorkingCopy() throws CoreException {
        return new AdjustedLaunchConfigurationWorkingCopy(this.extraVMArgument, this.delegate.getWorkingCopy(), this);
    }

    public Object getAdapter(Class adapter) {
        return this.delegate.getAdapter(adapter);
    }

    public boolean contentsEqual(ILaunchConfiguration configuration) {
        return this.delegate.contentsEqual(configuration);
    }

    public void delete() throws CoreException {
        this.delegate.delete();
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) throws CoreException {
        return this.delegate.getAttribute(attributeName, defaultValue);
    }

    public int getAttribute(String attributeName, int defaultValue) throws CoreException {
        return this.delegate.getAttribute(attributeName, defaultValue);
    }

    public List getAttribute(String attributeName, List defaultValue) throws CoreException {
        return this.delegate.getAttribute(attributeName, defaultValue);
    }

    public Set getAttribute(String attributeName, Set defaultValue) throws CoreException {
        return this.delegate.getAttribute(attributeName, defaultValue);
    }

    public Map getAttribute(String attributeName, Map defaultValue) throws CoreException {
        return this.delegate.getAttribute(attributeName, defaultValue);
    }

    public String getCategory() throws CoreException {
        return this.delegate.getCategory();
    }

    public IFile getFile() {
        return this.delegate.getFile();
    }

    public IPath getLocation() {
        return this.delegate.getLocation();
    }

    public IResource[] getMappedResources() throws CoreException {
        return this.delegate.getMappedResources();
    }

    public String getMemento() throws CoreException {
        return this.delegate.getMemento();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Set getModes() throws CoreException {
        return this.delegate.getModes();
    }

    public ILaunchDelegate getPreferredDelegate(Set modes) throws CoreException {
        return this.delegate.getPreferredDelegate(modes);
    }

    public ILaunchConfigurationType getType() throws CoreException {
        return this.delegate.getType();
    }

    public boolean isLocal() {
        return this.delegate.isLocal();
    }

    public boolean isMigrationCandidate() throws CoreException {
        return this.delegate.isMigrationCandidate();
    }

    public ILaunch launch(String mode, IProgressMonitor monitor) throws CoreException {
        return this.delegate.launch(mode, monitor);
    }

    public ILaunch launch(String mode, IProgressMonitor monitor, boolean build) throws CoreException {
        return this.delegate.launch(mode, monitor, build);
    }

    public ILaunch launch(String mode, IProgressMonitor monitor, boolean build, boolean register) throws CoreException {
        return this.delegate.launch(mode, monitor, build, register);
    }

    public void migrate() throws CoreException {
        this.delegate.migrate();
    }

    public boolean supportsMode(String mode) throws CoreException {
        return this.delegate.supportsMode(mode);
    }

    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }
}

