/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.docletapi;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.eclipse.ease.helpgenerator.AbstractModuleDoclet;
import org.eclipse.ease.helpgenerator.IReporter;
import org.eclipse.ease.helpgenerator.docletapi.Jep221ClassModel;
import org.eclipse.ease.helpgenerator.model.AbstractClassModel;
import org.eclipse.ease.helpgenerator.model.ModuleDefinition;

public class Jep221ModuleDoclet
extends AbstractModuleDoclet {
    private DocletEnvironment fEnvironment;
    private final Reporter fReporter;

    public Jep221ModuleDoclet(Reporter reporter) {
        this.fReporter = reporter;
    }

    @Override
    protected IReporter createReporter() {
        return new Java11DocletReporter(this.fReporter);
    }

    public void setDocletEnvironment(DocletEnvironment environment) {
        this.fEnvironment = environment;
    }

    @Override
    protected AbstractClassModel getClassModel(ModuleDefinition module) {
        for (Element element : this.fEnvironment.getIncludedElements()) {
            TypeElement typeElement;
            if (!ElementKind.CLASS.equals((Object)element.getKind()) || !(typeElement = (TypeElement)element).getQualifiedName().toString().equals(module.getClassName())) continue;
            Jep221ClassModel classModel = new Jep221ClassModel(this.fEnvironment, typeElement);
            ((AbstractClassModel)classModel).populateModel();
            return classModel;
        }
        return null;
    }

    private class Java11DocletReporter
    implements IReporter {
        private final Reporter fReporter;
        private boolean fHasErrors = false;

        public Java11DocletReporter(Reporter reporter) {
            this.fReporter = reporter;
        }

        @Override
        public void report(int status, String message) {
            switch (status) {
                case 0: {
                    this.fReporter.print(Diagnostic.Kind.NOTE, message);
                    break;
                }
                case 1: {
                    this.fReporter.print(Diagnostic.Kind.WARNING, message);
                    break;
                }
                default: {
                    this.fReporter.print(Diagnostic.Kind.ERROR, message);
                    this.fHasErrors = true;
                }
            }
        }

        @Override
        public boolean hasErrors() {
            return this.fHasErrors;
        }

        @Override
        public void reportMissingDocs(String message) {
            this.report(Jep221ModuleDoclet.this.failOnMissingDocs() ? 2 : 1, message);
        }

        @Override
        public void reportInvalidHtml(String message) {
            this.report(Jep221ModuleDoclet.this.failOnHtmlErrors() ? 2 : 1, message);
        }
    }
}

