/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db;

import java.io.IOException;
import java.util.Date;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.db.DBRepository;
import org.eclipse.dirigible.repository.db.dao.DBFileVersion;
import org.eclipse.dirigible.repository.db.dao.DBObject;

public class DBResourceVersion
implements IResourceVersion {
    private final DBRepository repository;
    private final RepositoryPath path;
    private int version;
    private DBFileVersion fileVersion;

    public DBResourceVersion(DBRepository repository, RepositoryPath path, int version) {
        this.repository = repository;
        this.path = path;
        this.version = version;
        this.fileVersion = this.getRepository().getRepositoryDAO().getFileVersionByPath(this.getPath(), version);
    }

    public DBRepository getRepository() {
        return this.repository;
    }

    public String getPath() {
        return this.path.toString();
    }

    protected DBObject getDBObject() throws IOException {
        return this.fileVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getContent() throws IOException {
        return this.fileVersion.getData();
    }

    public boolean isBinary() {
        return this.fileVersion.isBinary();
    }

    public String getContentType() {
        return this.fileVersion.getContentType();
    }

    public String getCreatedBy() {
        return this.fileVersion.getCreatedBy();
    }

    public Date getCreatedAt() {
        return this.fileVersion.getCreatedAt();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBResourceVersion)) {
            return false;
        }
        DBResourceVersion other = (DBResourceVersion)obj;
        return this.getPath().equals(other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public int compareTo(IResourceVersion o) {
        try {
            int x = this.getVersion();
            int y = o.getVersion();
            return x < y ? -1 : (x == y ? 0 : 1);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

