/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Assert;
import com.ibm.icu.impl.CharacterIteration;
import com.ibm.icu.text.DictionaryBreakEngine;
import com.ibm.icu.text.DictionaryData;
import com.ibm.icu.text.DictionaryMatcher;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

class CjkBreakEngine
extends DictionaryBreakEngine {
    private static final UnicodeSet fHangulWordSet = new UnicodeSet();
    private static final UnicodeSet fHanWordSet = new UnicodeSet();
    private static final UnicodeSet fKatakanaWordSet = new UnicodeSet();
    private static final UnicodeSet fHiraganaWordSet = new UnicodeSet();
    private DictionaryMatcher fDictionary = DictionaryData.loadDictionaryFor("Hira");
    private static final int kMaxKatakanaLength = 8;
    private static final int kMaxKatakanaGroupLength = 20;
    private static final int maxSnlp = 255;
    private static final int kint32max = Integer.MAX_VALUE;

    static {
        fHangulWordSet.applyPattern("[\\uac00-\\ud7a3]");
        fHanWordSet.applyPattern("[:Han:]");
        fKatakanaWordSet.applyPattern("[[:Katakana:]\\uff9e\\uff9f]");
        fHiraganaWordSet.applyPattern("[:Hiragana:]");
        fHangulWordSet.freeze();
        fHanWordSet.freeze();
        fKatakanaWordSet.freeze();
        fHiraganaWordSet.freeze();
    }

    public CjkBreakEngine(boolean korean) throws IOException {
        super(1);
        if (korean) {
            this.setCharacters(fHangulWordSet);
        } else {
            UnicodeSet cjSet = new UnicodeSet();
            cjSet = new UnicodeSet();
            cjSet.addAll(fHanWordSet);
            cjSet.addAll(fKatakanaWordSet);
            cjSet.addAll(fHiraganaWordSet);
            cjSet.add(65392);
            cjSet.add(12540);
            this.setCharacters(cjSet);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof CjkBreakEngine) {
            CjkBreakEngine other = (CjkBreakEngine)obj;
            return this.fSet.equals(other.fSet);
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static int getKatakanaCost(int wordlength) {
        int[] katakanaCost = new int[]{8192, 984, 408, 240, 204, 252, 300, 372, 480};
        return wordlength > 8 ? 8192 : katakanaCost[wordlength];
    }

    private static boolean isKatakana(int value) {
        return value >= 12449 && value <= 12542 && value != 12539 || value >= 65382 && value <= 65439;
    }

    public int divideUpDictionaryRange(CharacterIterator inText, int startPos, int endPos, DictionaryBreakEngine.DequeI foundBreaks) {
        StringCharacterIterator text;
        if (startPos >= endPos) {
            return 0;
        }
        inText.setIndex(startPos);
        int inputLength = endPos - startPos;
        int[] charPositions = new int[inputLength + 1];
        StringBuffer s = new StringBuffer("");
        inText.setIndex(startPos);
        while (inText.getIndex() < endPos) {
            s.append(inText.current());
            inText.next();
        }
        String prenormstr = s.toString();
        boolean isNormalized = Normalizer.quickCheck(prenormstr, Normalizer.NFKC) == Normalizer.YES || Normalizer.isNormalized(prenormstr, Normalizer.NFKC, 0);
        int numChars = 0;
        if (isNormalized) {
            text = new StringCharacterIterator(prenormstr);
            int index = 0;
            charPositions[0] = 0;
            while (index < prenormstr.length()) {
                int codepoint = prenormstr.codePointAt(index);
                charPositions[++numChars] = index += Character.charCount(codepoint);
            }
        } else {
            String normStr = Normalizer.normalize(prenormstr, Normalizer.NFKC);
            text = new StringCharacterIterator(normStr);
            charPositions = new int[normStr.length() + 1];
            Normalizer normalizer = new Normalizer(prenormstr, Normalizer.NFKC, 0);
            int index = 0;
            charPositions[0] = 0;
            while (index < normalizer.endIndex()) {
                normalizer.next();
                charPositions[++numChars] = index = normalizer.getIndex();
            }
        }
        int[] bestSnlp = new int[numChars + 1];
        bestSnlp[0] = 0;
        int i = 1;
        while (i <= numChars) {
            bestSnlp[i] = Integer.MAX_VALUE;
            ++i;
        }
        int[] prev = new int[numChars + 1];
        int i2 = 0;
        while (i2 <= numChars) {
            prev[i2] = -1;
            ++i2;
        }
        int[] values = new int[numChars];
        int[] lengths = new int[numChars];
        boolean is_prev_katakana = false;
        int i3 = 0;
        while (i3 < numChars) {
            text.setIndex(i3);
            if (bestSnlp[i3] != Integer.MAX_VALUE) {
                int maxSearchLength = i3 + 20 < numChars ? 20 : numChars - i3;
                int[] count_ = new int[1];
                this.fDictionary.matches(text, maxSearchLength, lengths, count_, maxSearchLength, values);
                int count = count_[0];
                if (!(count != 0 && lengths[0] == 1 || CharacterIteration.current32(text) == Integer.MAX_VALUE || fHangulWordSet.contains(CharacterIteration.current32(text)))) {
                    values[count] = 255;
                    lengths[count] = 1;
                    ++count;
                }
                int j = 0;
                while (j < count) {
                    int newSnlp = bestSnlp[i3] + values[j];
                    if (newSnlp < bestSnlp[lengths[j] + i3]) {
                        bestSnlp[lengths[j] + i3] = newSnlp;
                        prev[lengths[j] + i3] = i3;
                    }
                    ++j;
                }
                text.setIndex(i3);
                boolean is_katakana = CjkBreakEngine.isKatakana(CharacterIteration.current32(text));
                if (!is_prev_katakana && is_katakana) {
                    int newSnlp;
                    int j2 = i3 + 1;
                    CharacterIteration.next32(text);
                    while (j2 < numChars && j2 - i3 < 20 && CjkBreakEngine.isKatakana(CharacterIteration.current32(text))) {
                        CharacterIteration.next32(text);
                        ++j2;
                    }
                    if (j2 - i3 < 20 && (newSnlp = bestSnlp[i3] + CjkBreakEngine.getKatakanaCost(j2 - i3)) < bestSnlp[j2]) {
                        bestSnlp[j2] = newSnlp;
                        prev[j2] = i3;
                    }
                }
                is_prev_katakana = is_katakana;
            }
            ++i3;
        }
        int[] t_boundary = new int[numChars + 1];
        int numBreaks = 0;
        if (bestSnlp[numChars] == Integer.MAX_VALUE) {
            t_boundary[numBreaks] = numChars;
            ++numBreaks;
        } else {
            int i4 = numChars;
            while (i4 > 0) {
                t_boundary[numBreaks] = i4;
                ++numBreaks;
                i4 = prev[i4];
            }
            Assert.assrt(prev[t_boundary[numBreaks - 1]] == 0);
        }
        if (foundBreaks.size() == 0 || foundBreaks.peek() < startPos) {
            t_boundary[numBreaks++] = 0;
        }
        int correctedNumBreaks = 0;
        int i5 = numBreaks - 1;
        while (i5 >= 0) {
            int pos = charPositions[t_boundary[i5]] + startPos;
            if (!foundBreaks.contains(pos) && pos != startPos) {
                foundBreaks.push(charPositions[t_boundary[i5]] + startPos);
                ++correctedNumBreaks;
            }
            --i5;
        }
        if (!foundBreaks.isEmpty() && foundBreaks.peek() == endPos) {
            foundBreaks.pop();
            --correctedNumBreaks;
        }
        if (!foundBreaks.isEmpty()) {
            inText.setIndex(foundBreaks.peek());
        }
        return correctedNumBreaks;
    }
}

