/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.widget.extbrowser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExtendedBrowser {
    private static final String EMPTY_HTML = "<html><body></body></html>";
    private final Composite browserHolder;
    private Browser browser = null;

    public ExtendedBrowser(Composite composite, int style) {
        this.browserHolder = new Composite(composite, style);
        this.browserHolder.setLayout((Layout)new FillLayout());
        this.browser = new Browser(this.browserHolder, 0);
        this.browser.setText(EMPTY_HTML);
    }

    public Control getControl() {
        return this.browserHolder;
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public String getUrl() {
        return this.browser != null ? this.browser.getUrl() : null;
    }

    public void setUrl(String url) {
        if (this.browser == null) {
            return;
        }
        if (url == null) {
            this.browser.setText(EMPTY_HTML);
            return;
        }
        if (url.equals(this.browser.getUrl())) {
            Composite parent = this.browser.getParent();
            int style = this.browser.getStyle();
            this.browser.dispose();
            this.browser = new Browser(parent, style);
            parent.layout();
        }
        this.browser.setUrl(url);
    }

    public void refresh() {
        this.setUrl(this.getUrl());
    }

    public void setContent(String html) {
        if (this.browser != null) {
            if (html != null) {
                this.browser.setText(html);
            } else {
                this.browser.setText(EMPTY_HTML);
            }
        }
    }
}

