/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.common.status;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Control;

public class DefaultProgressMonitor
implements IProgressMonitor {
    private final IStatusLineManager statusLineManager = StatusLineManagerUtil.getDefaultStatusLineManager();

    public void beginTask(String name, int totalWork) {
        this.statusLineManager.setCancelEnabled(true);
        this.delegate().beginTask(name, totalWork);
        this.statusLineManager.update(true);
        if (this.statusLineManager instanceof SubStatusLineManager) {
            ((SubStatusLineManager)this.statusLineManager).getParent().update(true);
        }
    }

    private IProgressMonitor delegate() {
        return this.statusLineManager.getProgressMonitor();
    }

    public void done() {
        this.delegate().done();
        this.statusLineManager.update(true);
    }

    public void internalWorked(double work) {
        this.delegate().internalWorked(work);
    }

    public boolean isCanceled() {
        return this.delegate().isCanceled();
    }

    public void setCanceled(boolean value) {
        this.delegate().setCanceled(value);
    }

    public void setTaskName(String name) {
        this.delegate().setTaskName(name);
    }

    public void subTask(String name) {
        this.delegate().subTask(name);
    }

    public void worked(int work) {
        this.delegate().worked(work);
    }

    public Control getControl() {
        if (this.statusLineManager instanceof StatusLineManager) {
            return ((StatusLineManager)this.statusLineManager).getControl();
        }
        return null;
    }

    public void setMessage(String message) {
        this.statusLineManager.setMessage(message);
    }

    public void setMessage(String message, int severity) {
        String imageCode = null;
        switch (severity) {
            case 1: {
                imageCode = "dialog_messasge_info_image";
                break;
            }
            case 2: {
                imageCode = "dialog_messasge_warning_image";
                break;
            }
            case 4: {
                imageCode = "dialog_message_error_image";
            }
        }
        if (imageCode == null) {
            return;
        }
        this.statusLineManager.setMessage(JFaceResources.getImage((String)imageCode), message);
    }
}

