/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.TrimToolBarBase;

public class EditorAreaTrimToolBar
extends TrimToolBarBase {
    private boolean restoreOnUnzoom = false;
    private int paneOrientation;

    public EditorAreaTrimToolBar(WorkbenchWindow wbw) {
        super("org.eclipse.ui.editorss", 128, wbw);
        this.dock(128);
    }

    protected void restoreToPresentation() {
        Perspective persp = this.wbw.getActiveWorkbenchPage().getActivePerspective();
        persp.setEditorAreaState(2);
    }

    public void initToolBarManager(final ToolBarManager mgr) {
        ContributionItem restoreContrib = new ContributionItem(){

            public void fill(ToolBar parent, int index) {
                ToolItem restoreItem = new ToolItem(mgr.getControl(), 8, index);
                Image tbImage = WorkbenchImages.getImage("IMG_ETOOL_RESTORE_TRIMPART");
                restoreItem.setImage(tbImage);
                String menuTip = WorkbenchMessages.get().StandardSystemToolbar_Restore;
                restoreItem.setToolTipText(menuTip);
                restoreItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        EditorAreaTrimToolBar.this.restoreToPresentation();
                    }

                    public void widgetSelected(SelectionEvent e) {
                        EditorAreaTrimToolBar.this.restoreToPresentation();
                    }
                });
            }
        };
        mgr.add((IContributionItem)restoreContrib);
        ContributionItem eaContrib = new ContributionItem(){

            public void fill(ToolBar parent, int index) {
                ToolItem editorAreaItem = new ToolItem(mgr.getControl(), 8, index);
                Image tbImage = WorkbenchImages.getImage("IMG_ETOOL_EDITOR_TRIMPART");
                editorAreaItem.setImage(tbImage);
                String menuTip = WorkbenchMessages.get().EditorArea_Tooltip;
                editorAreaItem.setToolTipText(menuTip);
                editorAreaItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        EditorAreaTrimToolBar.this.restoreToPresentation();
                    }

                    public void widgetSelected(SelectionEvent e) {
                        EditorAreaTrimToolBar.this.restoreToPresentation();
                    }
                });
            }
        };
        mgr.add((IContributionItem)eaContrib);
    }

    public void hookControl(ToolBarManager mgr) {
    }

    public void setRestoreOnUnzoom(boolean restoreOnUnzoom) {
        this.restoreOnUnzoom = restoreOnUnzoom;
    }

    public boolean restoreOnUnzoom() {
        return this.restoreOnUnzoom;
    }

    public void setIconSelection(IViewReference ref, boolean selected) {
        ToolItem item = ShowFastViewContribution.getItem(this.tbMgr.getControl(), ref);
        if (item != null) {
            item.setSelection(selected);
        }
    }

    public int getPaneOrientation() {
        return this.paneOrientation;
    }
}

