/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.listkit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.swt.internal.widgets.IListAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOperationHandler
extends ControlOperationHandler<List> {
    private static final String PROP_TOP_INDEX = "topIndex";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_FOCUS_INDEX = "focusIndex";

    public ListOperationHandler(List list) {
        super(list);
    }

    @Override
    public void handleSet(List list, JsonObject properties) {
        super.handleSet(list, properties);
        this.handleSetTopIndex(list, properties);
        this.handleSetSelection(list, properties);
        this.handleSetFocusIndex(list, properties);
    }

    @Override
    public void handleNotify(List list, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(list, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(list, properties);
        } else {
            super.handleNotify(list, eventName, properties);
        }
    }

    public void handleSetTopIndex(List list, JsonObject properties) {
        JsonValue value = properties.get(PROP_TOP_INDEX);
        if (value != null) {
            list.setTopIndex(value.asInt());
        }
    }

    public void handleSetSelection(List list, JsonObject properties) {
        JsonValue value = properties.get(PROP_SELECTION);
        if (value != null) {
            JsonArray arrayValue = value.asArray();
            int[] selection = new int[arrayValue.size()];
            int i = 0;
            while (i < selection.length) {
                selection[i] = arrayValue.get(i).asInt();
                ++i;
            }
            list.setSelection(selection);
        }
    }

    public void handleSetFocusIndex(List list, JsonObject properties) {
        JsonValue value = properties.get(PROP_FOCUS_INDEX);
        if (value != null) {
            list.getAdapter(IListAdapter.class).setFocusIndex(value.asInt());
        }
    }

    public void handleNotifySelection(List list, JsonObject properties) {
        Event event = ListOperationHandler.createSelectionEvent(13, properties);
        list.notifyListeners(13, event);
    }

    public void handleNotifyDefaultSelection(List list, JsonObject properties) {
        Event event = ListOperationHandler.createSelectionEvent(14, properties);
        list.notifyListeners(14, event);
    }
}

