/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.core.text.StringMatcher;

public final class TextMatcher {
    private static final Pattern NON_WORD = Pattern.compile("\\W+", 256);
    private final StringMatcher full;
    private final List<StringMatcher> parts;

    public TextMatcher(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        this.full = new StringMatcher(pattern.trim(), ignoreCase, ignoreWildCards);
        this.parts = this.splitPattern(pattern, ignoreCase, ignoreWildCards);
    }

    private List<StringMatcher> splitPattern(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        String pat = pattern.trim();
        if (pat.isEmpty()) {
            return Collections.emptyList();
        }
        String[] subPatterns = pat.split("\\s+");
        if (subPatterns.length <= 1) {
            return Collections.emptyList();
        }
        ArrayList<StringMatcher> matchers = new ArrayList<StringMatcher>();
        String[] stringArray = subPatterns;
        int n = subPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && !s.isEmpty()) {
                StringMatcher m = new StringMatcher(s, ignoreCase, ignoreWildCards);
                m.usePrefixMatch();
                matchers.add(m);
            }
            ++n2;
        }
        return matchers;
    }

    public boolean match(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        return this.match(text, 0, text.length());
    }

    public boolean match(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            return false;
        }
        int tlen = text.length();
        if (this.full.match(text, start = Math.max(0, start), end = Math.min(end, tlen))) {
            return true;
        }
        String[] words = TextMatcher.getWords(text.substring(start, end));
        if (this.match(this.full, words)) {
            return true;
        }
        if (this.parts.isEmpty()) {
            return false;
        }
        for (StringMatcher subMatcher : this.parts) {
            if (subMatcher.match(text, start, end) || this.match(subMatcher, words)) continue;
            return false;
        }
        return true;
    }

    private boolean match(StringMatcher matcher, String[] words) {
        return Arrays.stream(words).filter(Objects::nonNull).anyMatch(arg_0 -> ((StringMatcher)matcher).match(arg_0));
    }

    public static String[] getWords(String text) {
        return NON_WORD.split(text);
    }

    public String toString() {
        return String.valueOf('[') + this.full.toString() + ',' + this.parts + ']';
    }
}

