/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;
import org.eclipse.pde.internal.ui.util.TextUtil;

public class CreateManifestClassResolution
extends AbstractManifestMarkerResolution {
    private String fHeader;

    public CreateManifestClassResolution(int type, String headerName, IMarker marker) {
        super(type, marker);
        this.fHeader = headerName;
    }

    @Override
    protected void createChange(BundleModel model) {
        IManifestHeader header = model.getBundle().getManifestHeader(this.fHeader);
        String name = TextUtil.trimNonAlphaChars(header.getValue()).replace('$', '.');
        IProject project = model.getUnderlyingResource().getProject();
        IPluginModelBase modelBase = PluginRegistry.findModel((IProject)project);
        if (modelBase == null) {
            return;
        }
        JavaAttributeValue value = new JavaAttributeValue(project, modelBase, null, name);
        if ((name = PDEJavaHelperUI.createClass(name, project, value, true)) != null && !name.equals(header.getValue())) {
            header.setValue(name);
        }
    }

    public String getLabel() {
        return NLS.bind((String)PDEUIMessages.CreateManifestClassResolution_label, (Object)this.fHeader);
    }
}

