/*
 * Copyright (c) 2018 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.map.primitive.MutableCharFloatMap;
import org.eclipse.collections.api.map.primitive.CharFloatMap;

/**
 * A factory which creates instances of type {@link MutableCharFloatMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableCharFloatMapFactory
{
    MutableCharFloatMap empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableCharFloatMap of();

    /**
     * Same as {@link #empty()}.
     */
    MutableCharFloatMap with();

    /**
     * Same as {@link #empty()}. but takes in an initial capacity
     */
    MutableCharFloatMap ofInitialCapacity(int capacity);

    /**
     * Same as {@link #empty()}. but takes in an initial capacity
     */
    MutableCharFloatMap withInitialCapacity(int capacity);

    /**
     * Same as {@link #withAll(CharFloatMap)}.
     */
    MutableCharFloatMap ofAll(CharFloatMap map);

    MutableCharFloatMap withAll(CharFloatMap map);

    /**
     * Creates an {@code MutableCharFloatMap} from an {@code Iterable<T>} by applying {@code keyFunction} and {@code valueFunction}.
     *
     * @since 10.0
     */
    <T> MutableCharFloatMap from(Iterable<T> iterable, CharFunction<? super T> keyFunction, FloatFunction<? super T> valueFunction);
}
