/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.epackage;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.loader.IClassLoader;
import org.eclipse.egf.core.epackage.IProxyEPackage;
import org.eclipse.egf.core.epackage.IProxyERoot;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.egf.core.internal.epackage.ProxyEClass;
import org.eclipse.egf.core.internal.epackage.ProxyEClassifier;
import org.eclipse.egf.core.internal.epackage.ProxyEDataType;
import org.eclipse.egf.core.internal.epackage.ProxyEPackage;
import org.eclipse.egf.core.internal.epackage.ProxyERoot;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ProxyFactory {
    private ProxyFactory() {
    }

    public static IProxyERoot buildIProxyERoot(IPlatformGenModel genModel) {
        if (genModel == null) {
            return null;
        }
        EPackage ePackage = genModel.getEPackage();
        if (ePackage == null) {
            return null;
        }
        ProxyERoot root = new ProxyERoot(genModel.getNsURI());
        ProxyEPackage proxy = new ProxyEPackage(root, ePackage.getName(), genModel.getGeneratedPackage(), genModel.getNsURI());
        root.addChildren(proxy);
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            proxy.addChildren(ProxyFactory.buildProxyEClassifier(proxy, eClassifier));
        }
        return root;
    }

    protected static ProxyEClassifier buildProxyEClassifier(IProxyEPackage proxy, EClassifier eClassifier) {
        if (eClassifier instanceof EClass) {
            return new ProxyEClass(proxy, eClassifier.getName(), eClassifier.getInstanceClassName(), EcoreUtil.getURI((EObject)eClassifier));
        }
        return new ProxyEDataType(proxy, eClassifier.getName(), eClassifier.getInstanceClassName(), EcoreUtil.getURI((EObject)eClassifier));
    }

    public static IProxyERoot buildIProxyERoot(IClassLoader loader, IPlatformGenModel genModel) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class clazz = loader.loadClass(genModel.getGeneratedPackage());
        Field field = clazz.getField("eINSTANCE");
        Object object = field.get(null);
        Method method = clazz.getMethod("getNsURI", new Class[0]);
        String nsURI = (String)method.invoke(object, new Object[0]);
        method = clazz.getMethod("getName", new Class[0]);
        String name = (String)method.invoke(object, new Object[0]);
        ProxyERoot root = new ProxyERoot(URI.createURI((String)nsURI));
        URI NsURI = URI.createURI((String)nsURI);
        ProxyEPackage proxy = new ProxyEPackage(root, name, genModel.getGeneratedPackage(), NsURI);
        root.addChildren(proxy);
        method = clazz.getMethod("getEClassifiers", new Class[0]);
        for (Object innerObject : (List)method.invoke(object, new Object[0])) {
            if ((innerObject = ProxyFactory.buildProxyEClassifier(loader, proxy, innerObject)) == null) continue;
            proxy.addChildren((ProxyEClassifier)innerObject);
        }
        return root;
    }

    protected static ProxyEClassifier buildProxyEClassifier(IClassLoader loader, IProxyEPackage proxy, Object object) throws IllegalArgumentException, IllegalAccessException, SecurityException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Method getName = object.getClass().getMethod("getName", new Class[0]);
        String name = (String)getName.invoke(object, new Object[0]);
        Class ecoreUtil = loader.loadClass("org.eclipse.emf.ecore.util.EcoreUtil");
        Class eObject = loader.loadClass("org.eclipse.emf.ecore.EObject");
        Method getUri = ecoreUtil.getMethod("getURI", eObject);
        Object innerObject = getUri.invoke((Object)ecoreUtil, eObject.cast(object));
        if (innerObject == null) {
            return null;
        }
        URI uri = URI.createURI((String)innerObject.toString());
        if ("org.eclipse.emf.ecore.impl.EClassImpl".equals(object.getClass().getName())) {
            return new ProxyEClass(proxy, name, EMFHelper.getInstanceClassName((IClassLoader)loader, (Object)object, (URI)uri), uri);
        }
        return new ProxyEDataType(proxy, name, EMFHelper.getInstanceClassName((IClassLoader)loader, (Object)object, (URI)uri), uri);
    }
}

