/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.pattern.PatternFolders;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.model.l10n.EGFModelMessages;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateModelFileHelper {
    public static String PATTERN_UNIT_FILE_EXTENSION = "pt";
    private static final String PATTERN_TOKEN = "pattern.";
    private static final String METHOD_TOKEN = "method.";

    private TemplateModelFileHelper() {
    }

    public static URI computeFileURI(IPlatformFcore fcore, PatternMethod method) {
        if (fcore == null) {
            throw new IllegalArgumentException(EGFModelMessages.fileHelper_error20);
        }
        if (method == null) {
            throw new IllegalArgumentException(EGFModelMessages.fileHelper_error4);
        }
        if (method.getID() == null) {
            throw new IllegalArgumentException(EGFModelMessages.fileHelper_error6);
        }
        if (method.getPattern() == null) {
            throw new IllegalArgumentException(EGFModelMessages.fileHelper_error7);
        }
        if (method.getPattern().getID() == null) {
            throw new IllegalArgumentException(EGFModelMessages.fileHelper_error8);
        }
        URI relativeURI = URI.createURI((String)(String.valueOf(PatternFolders.getTemplatesFolderName()) + '/' + PATTERN_TOKEN + method.getPattern().getID() + '/' + METHOD_TOKEN + method.getID() + '.' + PATTERN_UNIT_FILE_EXTENSION));
        return URI.createURI((String)(String.valueOf(fcore.getPlatformBundle().getRootedBase().toString()) + relativeURI.toString()));
    }

    public static String extractPatternId(IPath patternMethodPath) throws FilenameFormatException {
        if (patternMethodPath == null) {
            throw new FilenameFormatException(EGFModelMessages.PatternFilename_error1);
        }
        int segmentCount = patternMethodPath.segmentCount();
        if (segmentCount < 3) {
            throw new FilenameFormatException(NLS.bind((String)EGFModelMessages.PatternFilename_error2, (Object)patternMethodPath));
        }
        String segment = patternMethodPath.segment(segmentCount - 2);
        if (segment == null || "".equals(segment) || !segment.startsWith(PATTERN_TOKEN) || PATTERN_TOKEN.length() == segment.length()) {
            throw new FilenameFormatException(NLS.bind((String)EGFModelMessages.PatternFilename_error3, (Object)segment, (Object)PATTERN_TOKEN));
        }
        return segment.substring(PATTERN_TOKEN.length());
    }

    public static String extractPatternMethodId(IPath patternMethodPath) throws FilenameFormatException {
        if (patternMethodPath == null) {
            throw new FilenameFormatException(EGFModelMessages.PatternFilename_error1);
        }
        int segmentCount = patternMethodPath.segmentCount();
        if (segmentCount < 3) {
            throw new FilenameFormatException(NLS.bind((String)EGFModelMessages.PatternFilename_error2, (Object)patternMethodPath));
        }
        String segment = patternMethodPath.removeFileExtension().lastSegment();
        if (segment == null || "".equals(segment) || !segment.startsWith(METHOD_TOKEN) || METHOD_TOKEN.length() == segment.length()) {
            throw new FilenameFormatException(NLS.bind((String)EGFModelMessages.PatternFilename_error4, (Object)segment, (Object)METHOD_TOKEN));
        }
        return segment.substring(METHOD_TOKEN.length());
    }

    public static URI getTemplateURI(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(EGFModelMessages.fileHelper_error3);
        }
        if (uri.isRelative()) {
            throw new IllegalArgumentException(NLS.bind((String)EGFModelMessages.fileHelper_error5, (Object)uri.toString()));
        }
        return uri;
    }

    public static URI getTemplateURI(PatternMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(EGFModelMessages.fileHelper_error4);
        }
        return TemplateModelFileHelper.getTemplateURI(method.getPatternFilePath());
    }

    public static InputStream getInputStream(PatternMethod method) throws IOException {
        if (method == null) {
            throw new IllegalArgumentException(EGFModelMessages.fileHelper_error4);
        }
        return EGFPlatformPlugin.getPlatformURIConverter().createInputStream(TemplateModelFileHelper.getTemplateURI(method));
    }

    public static void restoreTemplates(IProgressMonitor monitor, IPlatformFcore fcore, List<PatternMethod> methods) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(methods != null ? 200 * methods.size() : 200));
        subMonitor.beginTask(null, methods != null ? 200 * methods.size() : 200);
        if (fcore == null || methods == null || methods.isEmpty()) {
            subMonitor.worked(200);
            return;
        }
        IProject project = fcore.getPlatformBundle().getProject();
        if (project == null) {
            subMonitor.worked(200);
            return;
        }
        for (PatternMethod method : methods) {
            IFileState[] states;
            if (method.getPatternFilePath() == null) {
                subMonitor.worked(200);
                continue;
            }
            IFile file = project.getFile(URIHelper.toPlatformProjectString((URI)method.getPatternFilePath(), (boolean)true));
            if (!file.exists() && (states = file.getHistory(monitor)) != null && states.length > 0) {
                IFileState[] iFileStateArray = states;
                int n = states.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileState state = iFileStateArray[n2];
                    if (state.exists()) {
                        FileHelper.createContainers((IProgressMonitor)subMonitor.newChild(100, 0), (IResource)file);
                        file.create(state.getContents(), false, (IProgressMonitor)subMonitor.newChild(100, 0));
                        break;
                    }
                    ++n2;
                }
            }
            subMonitor.worked(200);
        }
    }

    public static void removeTemplates(IProgressMonitor monitor, List<PatternMethod> methods) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(methods != null ? 100 * methods.size() : 100));
        subMonitor.beginTask(null, methods != null ? 100 * methods.size() : 100);
        if (methods == null || methods.isEmpty()) {
            subMonitor.worked(100);
            return;
        }
        for (PatternMethod method : methods) {
            if (method.getPatternFilePath() == null) {
                subMonitor.worked(100);
                continue;
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(method.getPatternFilePath().toPlatformString(true));
            if (resource != null) {
                FileHelper.deleteResource((IProgressMonitor)subMonitor.newChild(100, 0), (IResource)resource, (boolean)true);
                continue;
            }
            subMonitor.worked(100);
        }
    }

    public static class FilenameFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private FilenameFormatException(String message) {
            super(message);
        }
    }
}

