/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.views.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.views.outline.AbstractGraphicsTreeEditPart;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class DiagramTreeEditPart
extends AbstractGraphicsTreeEditPart {
    List<Diagram> diagrams;
    int id;

    public DiagramTreeEditPart(int id, Diagram diagram) {
        super(null, diagram);
        this.setDiagramEditPart(this);
        this.id = id;
    }

    public Diagram getDiagram() {
        return (Diagram)this.getModel();
    }

    public List<Diagram> getAllDiagrams() {
        if (this.diagrams == null) {
            this.diagrams = new ArrayList<Diagram>();
        }
        return this.diagrams;
    }

    protected void createEditPolicies() {
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> retList = new ArrayList<Object>();
        Diagram diagram = this.getDiagram();
        BPMNDiagram bpmnDiagram = (BPMNDiagram)BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)diagram);
        if (bpmnDiagram != null) {
            Definitions definitions = (Definitions)bpmnDiagram.eContainer();
            if (this.id == 0) {
                for (RootElement elem : definitions.getRootElements()) {
                    boolean addIt = true;
                    if (elem instanceof Process) {
                        TreeIterator iter = definitions.eAllContents();
                        while (iter.hasNext()) {
                            Participant participant;
                            EObject next = (EObject)iter.next();
                            if (!(next instanceof Participant) || (participant = (Participant)next).getProcessRef() != elem) continue;
                            addIt = false;
                            break;
                        }
                    }
                    if (!addIt) continue;
                    retList.add(elem);
                }
            } else if (this.id == 1) {
                retList.addAll(definitions.getDiagrams());
            }
            ResourceSet resourceSet = diagram.eResource().getResourceSet();
            for (BPMNDiagram bd : definitions.getDiagrams()) {
                this.getAllDiagrams().add(DIUtils.findDiagram((ResourceSet)resourceSet, (BPMNDiagram)bd));
            }
        }
        return retList;
    }

    @Override
    protected String getText() {
        BPMNDiagram bpmnDiagram = (BPMNDiagram)BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)this.getDiagram());
        if (bpmnDiagram != null && bpmnDiagram.getName() != null) {
            return bpmnDiagram.getName();
        }
        return "";
    }
}

