/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.data;

import java.util.List;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.features.DefaultMoveBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class MoveDataFeature
extends DefaultMoveBPMNShapeFeature {
    public MoveDataFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        Shape shape;
        EObject dataObject;
        if (super.canMoveShape(context) && (dataObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)(shape = context.getShape()))) instanceof ItemAwareElement) {
            if (dataObject instanceof FlowElement) {
                if (FeatureSupport.isValidDataTarget((ITargetContext)context)) {
                    return true;
                }
            } else {
                ContainerShape targetContainer = context.getTargetContainer();
                if (targetContainer == context.getSourceContainer()) {
                    return true;
                }
                EObject targetObject = FeatureSupport.getTargetObject((ITargetContext)context);
                if (targetObject instanceof Process) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void postMoveShape(IMoveShapeContext context) {
        ContainerShape targetContainer;
        Shape shape = context.getShape();
        ItemAwareElement dataObject = (ItemAwareElement)BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)shape);
        ContainerShape sourceContainer = context.getSourceContainer();
        if (sourceContainer != (targetContainer = context.getTargetContainer())) {
            EObject targetObject = FeatureSupport.getTargetObject((ITargetContext)context);
            if (dataObject instanceof FlowElement && targetObject != null) {
                List flowElements = ((FlowElementsContainer)targetObject).getFlowElements();
                if (flowElements != null) {
                    flowElements.add((FlowElement)dataObject);
                }
            } else {
                Resource resource = targetObject.eResource();
                InputOutputSpecification ioSpec = null;
                EStructuralFeature f = targetObject.eClass().getEStructuralFeature("ioSpecification");
                ioSpec = (InputOutputSpecification)targetObject.eGet(f);
                if (ioSpec == null) {
                    ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(targetObject);
                    ioSpec = (InputOutputSpecification)adapter.getFeatureDescriptor(f).createFeature(resource, null);
                    targetObject.eSet(f, (Object)ioSpec);
                }
                if (ioSpec.getInputSets().size() == 0) {
                    ioSpec.getInputSets().add(Bpmn2ModelerFactory.eINSTANCE.createInputSet());
                }
                if (ioSpec.getOutputSets().size() == 0) {
                    ioSpec.getOutputSets().add(Bpmn2ModelerFactory.eINSTANCE.createOutputSet());
                }
                InputOutputSpecification oldIoSpec = (InputOutputSpecification)dataObject.eContainer();
                if (dataObject instanceof DataInput) {
                    ioSpec.getDataInputs().add((DataInput)dataObject);
                    ((InputSet)ioSpec.getInputSets().get(0)).getDataInputRefs().add((DataInput)dataObject);
                    for (InputSet is : oldIoSpec.getInputSets()) {
                        is.getDataInputRefs().remove(dataObject);
                    }
                } else {
                    ioSpec.getDataOutputs().add((DataOutput)dataObject);
                    ((OutputSet)ioSpec.getOutputSets().get(0)).getDataOutputRefs().add((DataOutput)dataObject);
                    for (OutputSet os : oldIoSpec.getOutputSets()) {
                        os.getDataOutputRefs().remove(dataObject);
                    }
                }
            }
        }
        super.postMoveShape(context);
    }
}

